package com.ejianc.business.material.service.impl;

import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IUseApplyService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service("instore")
public class InstoreBpmService implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IInstoreService iInstoreService;


    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    IUseApplyService useApplyService;
    @Autowired
    private ICostDetailApi iCostDetailApi;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        logger.info("-----------审批节点审批中时节点审批后回调-----------");
        logger.info("开始时间-----------" + other.get("taskStartTime"));
        logger.info("审批意见-----------" + other.get("comment"));
        logger.info("other-----------" + other);
        return CommonResponse.success();
    }

    ;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
//		return CommonResponse.error("提交后手动失败测试");
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
//		return CommonResponse.error("撤回后手动失败测试");
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("审批通过后的回调开始-------------------");
        logger.info("审批通过后的回调，修改的状态------" + MaterialStoreState.STORED.getCode());
        return changeStoreState(billId, MaterialStoreState.STORED.getCode());
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        // 校验单据是否被成本分摊
        CommonResponse<String> response = iCostDetailApi.checkShareFlag(billId);
        if (!response.isSuccess()) {
            return CommonResponse.error(response.getMsg());
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("弃审后的回调开始-------------------");
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            logger.info("收料入库单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}", billId, billTypeCode, resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }
        logger.info("弃审后的回调，修改的状态------" + MaterialStoreState.STORED.getCode());

        CommonResponse<String> stringCommonResponse = changeStoreState(billId, MaterialStoreState.STORING.getCode());

        return stringCommonResponse;
    }

    public CommonResponse<String> changeStoreState(Long billId, Integer state) {
        InstoreEntity entity = iInstoreService.selectById(billId);
        if (entity == null) {
            CommonResponse.error("没有找到相关入库单！");
        }
        if (!ListUtil.isEmpty(entity.getInstoreMaterialList())) {
            entity.getInstoreMaterialList().forEach(sub -> {
                sub.setStoreState(state);
            });
        }
        iInstoreService.saveOrUpdate(entity, false);
        return CommonResponse.success();
    }
}
