package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.pub.MaterialAllocationState;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IOutStoreSubService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.*;
import com.ejianc.business.sub.api.ISubReportApi;
import com.ejianc.business.sub.vo.SettlePickDeductVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * @Author mrsir_wxp
 * @Date 2020/6/13 出库控制器
 * @Description OutStoreController
 */


@Controller
@RequestMapping("/outStore/")
public class OutStoreController {
    private static final String BILL_CODE = "MATERIAL-OUTSTORE";

    @Autowired
	IOutStoreService iOutStoreService;
    @Autowired
    IOutStoreSubService outStoreSubService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    IStoreService storeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISubReportApi subReportApi;

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/10  保存修改
     * @Description saveOrUpdate
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.Sub.vo.OutStoreVO>
     */
    @RequestMapping(value = "saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutStoreVO> saveOrUpdate(@RequestBody OutStoreVO vo) {
		beforeSave(vo);
        if(StringUtils.isBlank(vo.getBillCode())){
            vo.setBillCode(getAutoCode());
        }
        boolean checkResult = iOutStoreService.codeCheck(vo.getId(), vo.getBillCode());
        if (!checkResult) {
            return CommonResponse.error("保存失败，出库编码重复");
        }
        OutStoreEntity entity = BeanMapper.map(vo, OutStoreEntity.class);
//        if(entity.getId() == null || entity.getId() == 0){
//            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
//            if(billCode.isSuccess()) {
//                entity.setBillCode(billCode.getData());
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
        List<OutStoreSubEntity> outStoreSubEntities = entity.getOutStoreSubEntities();
        if (ListUtil.isNotEmpty(outStoreSubEntities) && null==vo.getId()){
            for (OutStoreSubEntity outStoreSubEntity : outStoreSubEntities) {
                if (!"del".equals(outStoreSubEntity.getRowState())){
                    //查询已被占用数量
                    BigDecimal inNum = storeService.calculateCanUseNum(outStoreSubEntity.getSourceSubId(), outStoreSubEntity.getMaterialId(), null);
                    if (ComputeUtil.isGreaterThan(outStoreSubEntity.getOutStoreNumber(),inNum)){
                        throw new BusinessException("物资【"+outStoreSubEntity.getMaterialName()+"】已被使用完毕，请刷新后重新制单！");
                    }
                }
            }
        }
        iOutStoreService.saveOrUpdate(entity,false);
        OutStoreVO backVo = BeanMapper.map(entity, OutStoreVO.class);
        return CommonResponse.success("保存或修改单据成功！",backVo);
    }
    /**
     * 获取自动生成编码并校验重复
     *
     * @return
     */
    private String getAutoCode() {
        String code = null;

        while (StringUtils.isBlank(code)) {
            CommonResponse<String> resp = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!resp.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            code = resp.getData();
        }

        return code;
    }
    public void beforeSave(OutStoreVO vo){
        BigDecimal totalAmountNoTax = new BigDecimal(0);
        if(!ListUtil.isEmpty(vo.getOutStoreSubEntities())){
    		for(OutStoreSubVO sub:vo.getOutStoreSubEntities()){
                if(!"del".equals(sub.getRowState())){
                    sub.setStoreId(vo.getStoreId());
                    sub.setStoreType(vo.getStoreType());
                    sub.setOutDate(vo.getOutDate());
                    /** 新增和修改 均为占用态 */
                    sub.setStoreState(MaterialStoreState.OCCUPY.getCode());
                    totalAmountNoTax = totalAmountNoTax.add(sub.getAmount()==null?new BigDecimal("0.00"):
                            sub.getAmount().divide(new BigDecimal("1.00").add(sub.getTaxRate()==null?new BigDecimal("0.00"):sub.getTaxRate().divide(new BigDecimal("100.00"),8,BigDecimal.ROUND_HALF_UP)),8,BigDecimal.ROUND_HALF_UP)
                            );
                }
			}
		}
        vo.setOutMoneyNoTax(totalAmountNoTax);
    }

    /***
     * @Author mrsir_wxp
     * @Date 2020/12/22 保存 关联 领料退库使用
     * @Description pushToCost
     * @Param [vo]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.material.vo.InstoreVO>
     */
    @RequestMapping(value = "pushToCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutStoreVO> pushToCost(@RequestBody OutStoreVO vo) {
        beforeSave(vo);
        OutStoreEntity entity = BeanMapper.map(vo, OutStoreEntity.class);
        iOutStoreService.processCost(entity);
        iOutStoreService.saveOrUpdate(entity,false);
        OutStoreVO backVo = BeanMapper.map(entity, OutStoreVO.class);
        return CommonResponse.success("保存关联成功！",backVo);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/2 查询详情
     * @Description queryDetail
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.Sub.vo.OutStoreVO>
     */
    @RequestMapping(value = "queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutStoreVO> queryDetail(Long id) {
        OutStoreEntity entity = iOutStoreService.selectById(id);
        OutStoreVO vo = BeanMapper.map(entity, OutStoreVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialNames");
        fuzzyFields.add("orgName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("useFor");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("creatorName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("receivePerson");
        fuzzyFields.add("contractName");
        fuzzyFields.add("inOrgName");
        //租户隔离
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        //param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        return CommonResponse.success("查询列表数据成功！",iOutStoreService.queryForList(param,false));
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/10 查询打印数据
     * @Description queryPrint
     * @Param [id]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("store",iOutStoreService.selectById(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2020/6/10 删除
     * @Description delete
     * @Param [vos]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutStoreVO> vos) {
    	iOutStoreService.removeByIds(vos.stream().map(OutStoreVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    /**
     * @Author mrsir_wxp
     * @Date 2020/6/10 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialNames");
        fuzzyFields.add("orgName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("useFor");
        fuzzyFields.add("projectName");

        /** 数据隔离 本下 */
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<OutStoreVO>  voPage = iOutStoreService.queryForList(queryParam,false);
        List<OutStoreVO> list = voPage.getRecords();
        List<OutStoreExportVO> exportVOS = new ArrayList<>();
        if(ListUtil.isNotEmpty(list)){
            list.forEach(vo->{
                OutStoreExportVO exportVO = BeanMapper.map(vo,OutStoreExportVO.class);
                exportVO.setCreateTime(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getCreateTime()));
                exportVO.setOutDate(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getOutDate()));
                if(StringUtils.isNotBlank(vo.getReceiveState())){
                    exportVO.setReceiveState(MaterialAllocationState.TO_RECEIVING.getCode().equals(vo.getReceiveState())?"待收":
                            (MaterialAllocationState.RECEIVED.getCode().equals(vo.getReceiveState())?"已收":
                                    "已退回："+vo.getReturnReason()));
                }
                exportVO.setBillState(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                String outNum = exportVO.getOutNum();
                String outMoney = exportVO.getOutMoney();
                if (StringUtils.isNotEmpty(outNum)){
                    if (outNum.equals("0E-8")){
                        exportVO.setOutNum("0");
                    }
                }
                if (StringUtils.isNotEmpty(outMoney)){
                    if (outMoney.equals("0E-8")){
                        exportVO.setOutMoney("0.00");
                    }
                }
                exportVOS.add(exportVO);
            });
        }
        
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        if(queryParam.getParams().get("storeType").getValue().equals(MaterialStoreType.ALLOCATION_OUT_STORE.getCode())){
            ExcelExport.getInstance().export("allocationOutExport.xlsx", beans, response);
        }else if(queryParam.getParams().get("storeType").getValue().equals(MaterialStoreType.PICKING_OUT_STORE.getCode())){
            ExcelExport.getInstance().export("pickingOutExport.xlsx", beans, response);
        }else if(queryParam.getParams().get("storeType").getValue().equals(MaterialStoreType.RETURN_GOODS_OUT_STORE.getCode())){
            ExcelExport.getInstance().export("returnGoodsListExport.xlsx", beans, response);
        }
    }
    
    /**
     * @Author liyongjai
     * @Date 2020/6/18 出库单参照
     * @Return 
     * 
     */
    @RequestMapping(value = "queryOutStoreMaterialList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutStoreSubVO>> queryOutStoreMaterialList(
    		@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
    		@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition,
            @RequestParam(required = false) String searchObject) {
    	
    	Long storeId = null;
    	Long projectId = null;
    	String outDate = null;
    	if(StringUtils.isNotBlank(condition)){
    		JSONObject json = JSONObject.parseObject(condition);
    		if(json.get("storeId")!=null){
    			storeId = Long.parseLong(json.get("storeId").toString());
    		}else {
                return CommonResponse.error("condition条件缺少storeId（仓库id）！");
            }
    		if(json.get("outDate")!=null){
    			outDate = json.get("outDate").toString();
    		}else {
                return CommonResponse.error("condition条件缺少outDate(出库日期)！");
            }
            if(json.get("projectId")!=null){
                projectId = Long.parseLong(json.get("projectId").toString());
            }
    	}else {
    	    return CommonResponse.error("缺少condition条件");
        }
    	String storeType = "5,6";//领料出库,直接出库 
        return CommonResponse.success("查询列表数据成功！",outStoreSubService.queryOutStoreMaterialList(pageNumber,pageSize,storeId,outDate,storeType,searchText,searchObject,projectId));
    }


    @RequestMapping(value = "queryRefNotSettlementList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutStoreVO>> queryRefNotSettlementList(
        @RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
        @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        if(StringUtils.isNotBlank(condition)){
            JSONObject json = JSONObject.parseObject(condition);
            if(json.get("orgId")!=null){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ,json.get("orgId")));
            }else {
                return CommonResponse.error("condition条件缺少orgId！");
            }
            if(json.get("contractId")!=null){
                param.getParams().put("contractId", new Parameter(QueryParam.EQ,json.get("contractId")));
            }
        }else {
            return CommonResponse.error("缺少condition条件");
        }
        param.getParams().put("storeType", new Parameter(QueryParam.EQ,"8"));
        param.getParams().put("billState", new Parameter(QueryParam.IN,"1,3"));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        param.getOrderMap().put("createTime",QueryParam.DESC);

        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("settlementFlag", new Parameter(QueryParam.EQ, "0"));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        c3.getParams().put("settlementFlag", new Parameter(QueryParam.EQ, null));
        c1.getComplexParams().add(c3);

        param.getComplexParams().add(c1);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("materialNames");
        IPage<OutStoreVO> page = iOutStoreService.queryForList(param,false);
        setType(page.getRecords());
        return CommonResponse.success("查询列表数据成功！",page);
    }
    public void setType(List< OutStoreVO > list){
        if(ListUtil.isNotEmpty(list)){
            list.forEach(l-> {
                OutStoreEntity entity = iOutStoreService.selectById(l.getId());
                if(ListUtil.isNotEmpty(entity.getOutStoreSubEntities())){
                    List<OutStoreSubEntity> entities = entity.getOutStoreSubEntities();
                    l.setOutStoreSubEntities(BeanMapper.mapList(entities, OutStoreSubVO.class));
                }
                l.setStoreTypeName(MaterialStoreType.getStoreTypeNameByCode(l.getStoreType()));
            });
        }
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/2/21 查询物资开累年累消耗top n
     * @Description queryMaterialCostTopN
     * @Param topN 消耗前几位
     * @Param type 1、开累，2、年累  默认年累top5
     * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.alibaba.fastjson.JSONObject>>
     */
    @RequestMapping(value = "queryMaterialCostTopN", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryMaterialCostTopN(@RequestParam(value = "topN",defaultValue = "5") Integer topN,@RequestParam(value = "type",defaultValue = "2") Integer type){
        return iOutStoreService.queryMaterialCostTopN(topN,type);
    }

    @RequestMapping(value = "queryMaterialNumTopN", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryMaterialNumTopN(@RequestParam QueryParam queryParam){
        List<Long> orgIdList = null;
        List<Long> sectionIds = null;
        Parameter orgIds = queryParam.getParams().get("orgIds");
        Parameter sectionIdPa = queryParam.getParams().get("sectionIds");
        if(orgIds != null && orgIds.getValue() != null){
            orgIdList = Arrays.stream(orgIds.getValue().toString().split(",")).map(t -> Long.valueOf(t)).collect(Collectors.toList());
        } else {
            orgIdList = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }

        if(sectionIdPa != null && sectionIdPa.getValue() != null){
            sectionIds = Arrays.stream(sectionIdPa.getValue().toString().split(",")).map(t -> Long.valueOf(t)).collect(Collectors.toList());
        }

        return iOutStoreService.queryMaterialNumTopN(Integer.valueOf(queryParam.getParams().get("topN").toString()), orgIdList, sectionIds);
    }

    /**
     * @param vo
     * @description: 物资出库数量>=总计划数量X%校验
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.finance.vo.ParamsCheckVO>
     * @author jiangyikai
     * @date: 2022-04-11
     */
    @RequestMapping(value = "checkParams", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody MaterialPriceVO vo) {

        ParamsCheckVO paramsCheckVO = iOutStoreService.checkParams(vo);

        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }
    /**
     * 查询物资超出领料登记的限额参照
     * @param pageNumber
     * @param pageSize
     * @param searchText
     * @param condition
     * @return
     */
    @RequestMapping(value = "queryPickDeductList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PickRegisterDetailVO>> queryPickDeductList(
            @RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
            @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnitName");
        Long projectId=null;
        Long supplierId=null;
        if(StringUtils.isNotBlank(condition)){
            JSONObject json = JSONObject.parseObject(condition);
            if(json.get("projectId")!=null){
                projectId = Long.parseLong(json.get("projectId").toString());
            }
            if(json.get("supplierId")!=null){
                supplierId = Long.parseLong(json.get("supplierId").toString());
            }
        }else {
            return CommonResponse.error("缺少condition条件");
        }
        /** 数据隔离 本下 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<PickRegisterDetailVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<PickRegisterDetailVO> pickDeductList=iOutStoreService.queryPickDeductList(page,wrapper,projectId,supplierId);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        queryParam.getParams().put("supplierId",new Parameter(QueryParam.EQ,supplierId));
        List<SettlePickDeductVO> list = new ArrayList<>();
        CommonResponse<List<SettlePickDeductVO>> listCommonResponse = subReportApi.queryLastSettlePickDeductMnyList(queryParam);
        if (listCommonResponse.isSuccess()){
            list = listCommonResponse.getData();
        }
        Map<Long, BigDecimal> deductMnymap = list.stream().collect(Collectors.toMap(SettlePickDeductVO::getMaterialId,
                SettlePickDeductVO::getDeductMny));
        for (PickRegisterDetailVO pickRegisterDetailVO : pickDeductList) {
            Long materialId = pickRegisterDetailVO.getMaterialId();
            BigDecimal deductMny = deductMnymap.get(materialId);
            pickRegisterDetailVO.setDeductMny(deductMny);
        }
        page.setTotal(page.getTotal());
        page.setRecords(pickDeductList);
        return CommonResponse.success("查询列表数据成功！",page);
    }
}
