package com.ejianc.business.material.service.impl;

import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.pub.MaterialAllocationState;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.pub.MessageUtil;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Service("outStore")
public class OutStoreBpmService implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    MessageUtil messageUtil;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    IOutStoreService iOutStoreService;

    @Autowired
    IInstoreService instoreService;

    @Autowired
    private ICostDetailApi iCostDetailApi;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
    	logger.info("审批通过后的回调开始-------------------");
    	logger.info("审批通过后的回调，修改的状态------"+MaterialStoreState.STORED.getCode());
        //插入调拨入库



        return changeStoreState(billId,MaterialStoreState.USED.getCode());
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity entity = iOutStoreService.selectById(billId);
        if(entity == null){
            return CommonResponse.error("没有找到当前单据信息，无法弃审！");
        }
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()) {
            logger.info("出库单单据【billId-{}】,【billTypeCode-{}】执行撤回操作校验结束，未通过校验，原因：{}",billId,billTypeCode, resp.getMsg());
            return CommonResponse.error(resp.getMsg());
        }
        if(Objects.equals(entity.getStoreType(), MaterialStoreType.ALLOCATION_OUT_STORE.getCode())){//调拨出库
            return CommonResponse.error("已调入【"+entity.getInOrgName()+"】，无法弃审！");
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
    	logger.info("弃审后的回调开始-------------------");
    	logger.info("弃审后的回调，修改的状态------"+MaterialStoreState.STORED.getCode());
        return changeStoreState(billId,MaterialStoreState.OCCUPY.getCode());
    }

    public CommonResponse<String> changeStoreState(Long billId,Integer state){
        logger.info("changeStoreState-------------------");
        OutStoreEntity entity = iOutStoreService.selectById(billId);
        if(entity==null){
            CommonResponse.error("没有找到相关出库单！");
        }
        if(!ListUtil.isEmpty(entity.getOutStoreSubEntities())){
            entity.getOutStoreSubEntities().forEach(sub->{
                sub.setStoreState(state);
            });
        }

        if(Objects.equals(entity.getStoreType(), MaterialStoreType.PICKING_OUT_STORE.getCode())){//领料出库
            /** 领料退库 & 直入直出 成本处理*/
            processCostState(entity,state);
        }
        if(Objects.equals(entity.getStoreType(), MaterialStoreType.ALLOCATION_OUT_STORE.getCode())){//调拨出库
            processALLOCATION_OUT_STORE(entity,state);
        }
        iOutStoreService.saveOrUpdate(entity,false);
        return CommonResponse.success();
    }

    private void processALLOCATION_OUT_STORE(OutStoreEntity entity,Integer state){
        if(Objects.equals(MaterialStoreState.USED.getCode(), state)){//审批通过回调
            InstoreEntity vo = new InstoreEntity();
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode("MATERIAL-INSTORE", InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                vo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，调入单号生成失败，请稍后再试");
            }
            vo.setId(IdWorker.getId());
            vo.setMaterialName(entity.getMaterialNames());
            vo.setTotalAmount(entity.getOutMoney());
            vo.setTotalCount(entity.getOutNum());
            vo.setOutId(entity.getId());
            vo.setInstoreDate(entity.getOutDate());
            vo.setInstoreType(MaterialStoreType.ALLOCATION_IN_STORE.getCode());
            vo.setOutOrgId(entity.getOrgId());
            vo.setOutOrgName(entity.getOrgName());
            vo.setOutStoreId(entity.getStoreId());
            vo.setOutStoreName(entity.getStoreName());
            vo.setOrgId(entity.getInOrgId());
            vo.setOutProjectId(entity.getProjectId());
            vo.setOutProjectName(entity.getProjectName());
            vo.setProjectFlag(entity.getInBelongToProject());
            vo.setOrgName(entity.getInOrgName());
            vo.setProjectId(entity.getInProjectId());
            vo.setProjectName(entity.getInProjectName());
            vo.setReceiveState(MaterialAllocationState.TO_RECEIVING.getCode());
            vo.setNote(entity.getMemo());
            vo.setSectionDocId(entity.getInSectionDocId());
            vo.setSectionDocName(entity.getInSectionDocName());
            vo.setOutSectionDocId(entity.getSectionDocId());
            vo.setOutSectionDocName(entity.getSectionDocName());
            List<InstoreMaterialEntity> materialVOS = vo.getInstoreMaterialList();
            List<OutStoreSubEntity> outStoreSubs =entity.getOutStoreSubEntities();
            if(!ListUtil.isEmpty(outStoreSubs)){
                outStoreSubs.forEach(o->{
                    InstoreMaterialEntity materialVO = BeanMapper.map(o,InstoreMaterialEntity.class);
                    materialVO.setId(null);
                    materialVO.setVersion(null);
                    materialVO.setInstoreDate(vo.getInstoreDate());
                    materialVO.setStoreState(MaterialStoreState.STORING.getCode());
                    materialVO.setInstoreNumber(o.getOutStoreNumber());
                    materialVO.setInstoreType(MaterialStoreType.ALLOCATION_IN_STORE.getCode());
                    materialVO.setSectionId(entity.getInSectionDocId());
                    materialVO.setSectionName(entity.getInSectionDocName());
                    materialVOS.add(materialVO);
                });
            }
            instoreService.saveOrUpdate(vo,false);
            sendMessageToNoticePerson(entity.getNoticeToReceive(),vo.getBillCode(),vo.getId());
        }else {//撤回回调
            throw new BusinessException("已调入【"+entity.getInOrgName()+"】，无法撤回！");
        }
    }

    private void sendMessageToNoticePerson(Long receiveId,String billCode,Long billId){
        if(receiveId!=null){
            List<String> messageType = new ArrayList<>();
            List<String> receivers = new ArrayList<>();
            messageType.add("sys");
            receivers.add(receiveId.toString());
            String formurl = baseHost +"ejc-material-frontend/#/allocationIn/card?id="+billId;
            String subject = "材料调拨入库提醒";
            String content = "收到调拨入库材料单【"+billCode+"】请及时处理！。<a href=" + '"' + formurl + '"' + ">立即处理</a>";
            messageUtil.sendMsg(messageType, receivers, "notice", subject, content);
        }
    }

    /** 成本处理  */
    public void processCostState(OutStoreEntity entity,Integer process){
        if(process == MaterialStoreState.USED.getCode()){//审批通过
            iOutStoreService.processCost(entity);
        }else {//弃审
            iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }
}
