package com.ejianc.business.material.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ComparePriceSubVO extends BaseVO {
    /**
     * 主表id
     */
    private Long pid;

    /**
     * 物资分类名称
     */
    private String materialTypeName;


    /**
     * 物资分类id
     */
    private Long materialTypeId;

    /**
     * 物资名称
     */
    private String materialName;

    /**
     * 物资id
     */
    private Long materialId;

    /**
     * 规格型号
     */
    private String model;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 数量
     */
    private BigDecimal num;

    /**
     * 品牌
     */
    private java.lang.String supplierName;


    /** 以下字段用于参照使用 ************************************/
    /**
     * 推荐价格
     */
    private String recommendPrice;

    /**
     * 推荐金额
     */
    private String recommendMoney;
    /** 以上字段用于参照使用 end************************************/

    /**
     * 物资来源类型：1-物料档案，2-用料申请
     */
    private String sourceType;

    private List<ComparePriceSelectedSupplierVO> supplierEntities = new ArrayList<>();

    /**
     * 物资编码
     */
    private String materialCode;

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    @ReferSerialTransfer(referCode="MaterialCategory001")
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    @ReferDeserialTransfer
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    @ReferSerialTransfer(referCode="Material001")
    public Long getMaterialId() {
        return materialId;
    }

    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public List<ComparePriceSelectedSupplierVO> getSupplierEntities() {
        return supplierEntities;
    }

    public void setSupplierEntities(List<ComparePriceSelectedSupplierVO> supplierEntities) {
        this.supplierEntities = supplierEntities;
    }

    public String getRecommendPrice() {
        return recommendPrice;
    }

    public void setRecommendPrice(String recommendPrice) {
        this.recommendPrice = recommendPrice;
    }

    public String getRecommendMoney() {
        return recommendMoney;
    }

    public void setRecommendMoney(String recommendMoney) {
        this.recommendMoney = recommendMoney;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
}
