package com.ejianc.business.material.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 采购订单子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_purchase_order_detail")
public class PurchaseOrderDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="pid")
    private Long pid; // 主表id
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资分类id
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资分类名称
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="model")
    private String model; // 规格型号
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商品牌id
    @TableField(value="supplier_name")
    private String supplierName; // 品牌
    @TableField(value="order_num")
    private BigDecimal orderNum; // 订货量
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="source_type")
    private Integer sourceType; // 物资来源类型：1-物资档案，2-用料申请，3-合同清单，4-导入
    @TableField(value="source_id")
    private Long sourceId; // 物资来源单据Id
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 金额
    /**
     * 物资编码
     */
    @TableField(value = "material_code")
    private String materialCode;

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public BigDecimal getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(BigDecimal orderNum) {
        this.orderNum = orderNum;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    
}
