package com.ejianc.business.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.plan.bean.*;
import com.ejianc.business.plan.mapper.*;
import com.ejianc.business.plan.service.IMaterialMasterPlanService;
import com.ejianc.business.plan.service.ISectionPlanChangeHisService;
import com.ejianc.business.plan.service.ISectionPlanService;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.plan.service.ISectionPlanChangeService;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标段计划变更
 * 
 * @author generator
 * 
 */
@Service("sectionPlanChangeService")
public class SectionPlanChangeServiceImpl extends BaseServiceImpl<SectionPlanChangeMapper, SectionPlanChangeEntity> implements ISectionPlanChangeService{

    @Autowired
    private ISectionPlanService sectionPlanService;

    @Autowired
    private SectionPlanChangeSubMapper sectionPlanChangeSubMapper;

    @Autowired
    private SectionPlanChangeHisMapper planChangeHisMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SectionPlanChangeEntity saveOrUpdatePlanChange(SectionPlanChangeEntity saveEntity) {
        if(CollectionUtils.isNotEmpty(saveEntity.getMaterialSubList())) {
            //更新子表信息
            if(null != saveEntity.getId()) {
                sectionPlanChangeSubMapper.delByPlanId(saveEntity.getId());
            }
        }
        super.saveOrUpdate(saveEntity, false);

        SectionPlanEntity planEntity = sectionPlanService.selectById(saveEntity.getSourcePlanId());
        if(1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingPlanId(saveEntity.getId());
            sectionPlanService.saveOrUpdate(planEntity, false);
        }
        return saveEntity;
    }

    @Override
    public void deleteChangePlan(List<Long> changeIds) {
        List<SectionPlanChangeEntity> changeList = baseMapper.selectBatchIds(changeIds);
        List<Long> planIds = changeList.stream().map(SectionPlanChangeEntity::getSourcePlanId).collect(Collectors.toList());

        QueryWrapper<SectionPlanEntity> planQuery = new QueryWrapper<>();
        planQuery.in("id", planIds);
        List<SectionPlanEntity> planList = sectionPlanService.list(planQuery);

        //查询已有的变更历史记录
        QueryWrapper<SectionPlanChangeHisEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, source_plan_id as planId");
        query.in("source_plan_id", planIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("source_plan_id");

        List<Map<String, Object>> queryResult = planChangeHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });

        for(SectionPlanEntity plan : planList) {
            plan.setChangeState((null !=hisCountNumMap.get(plan.getId()) && hisCountNumMap.get(plan.getId()) > 0) ? 2 : 0); //未变更
            plan.setCurChangingPlanId(null);
        }
        sectionPlanService.saveOrUpdateBatch(planList, planList.size());
        super.removeByIds(changeList.stream().map(SectionPlanChangeEntity::getId).collect(Collectors.toList()), false);

    }
}
