/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.ejianc.business.material.bean.ContractChangeEntity;
import com.ejianc.business.material.bean.MaterialContractEntity;
import com.ejianc.business.material.mapper.ContractChangeMapper;
import com.ejianc.business.material.service.IContractChangeService;
import com.ejianc.business.material.service.IContractRecordService;
import com.ejianc.business.material.service.IMaterialContractService;
import com.ejianc.business.material.vo.ContractChangeVO;
import com.ejianc.business.material.vo.ContractDetailChangeVO;
import com.ejianc.business.material.vo.ContractOtherCostChangeVO;
import com.ejianc.business.material.vo.MaterialContractVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractChangeService")
public class ContractChangeServiceImpl
extends BaseServiceImpl<ContractChangeMapper, ContractChangeEntity>
implements IContractChangeService {
    @Autowired
    private IMaterialContractService materialContractService;
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractRecordService contractRecordService;

    @Override
    public ContractChangeVO save(ContractChangeVO contractChangeVO) {
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.materialContractService.selectById(contractChangeVO.getMaterialContractId()));
        ContractChangeEntity saveEntity = null;
        ContractChangeEntity dbEntity = null;
        UserContext userContext = this.sessionManager.getUserContext();
        BigDecimal totalAmountWith = new BigDecimal(0).setScale(8, 4);
        if (null == contractChangeVO.getId() || this.contractChangeService.getById(contractChangeVO.getId()) == null) {
            contractChangeVO.setChangeVersion(Integer.valueOf(contract.getChangeVersion() + 1));
            contractChangeVO.setBaseMoney(contract.getBaseMoney());
            contractChangeVO.setBaseTaxMoney(contract.getBaseTaxMoney());
            contractChangeVO.setBeforeChangeMny(contract.getAmountWithoutTax());
            contractChangeVO.setBeforeChangeTaxMny(contract.getAmountWithTax());
            contractChangeVO.setBeforeContractName(contract.getName());
            contractChangeVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            contractChangeVO.setChangeDate(new Date());
            contractChangeVO.setCreateUserName(userContext.getUserName());
            contract.setChangeState(MaterialContractVO.CONTRACT_CHANGE_STATE_CHANGING);
            contract.setChangeId(contractChangeVO.getId());
            contract.setChangeBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        } else {
            dbEntity = (ContractChangeEntity)((Object)super.selectById((Serializable)contractChangeVO.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getMaterialDetailList())) {
            contractChangeVO.getMaterialDetailList().stream().filter(detail -> null == detail.getChangeId()).forEach(detail -> {
                detail.setId(null);
                detail.setMaterialContractId(contract.getId());
                detail.setChangeId(contractChangeVO.getId());
            });
            totalAmountWith = totalAmountWith.add(contractChangeVO.getMaterialDetailList().stream().filter(detail -> !"6".equals(detail.getChangeType()) && null != detail.getTotalAmount()).map(ContractDetailChangeVO::getTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getOtherCostList())) {
            contractChangeVO.getOtherCostList().stream().filter(cost -> null == cost.getChangeId()).forEach(cost -> {
                cost.setId(null);
                cost.setMaterialContractId(contract.getId());
                cost.setChangeId(contractChangeVO.getId());
            });
            totalAmountWith = totalAmountWith.add(contractChangeVO.getOtherCostList().stream().filter(cost -> null != cost.getCostAmount()).map(ContractOtherCostChangeVO::getCostAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getContractItemList())) {
            contractChangeVO.getContractItemList().stream().filter(item -> null == item.getChangeId()).forEach(item -> {
                item.setId(null);
                item.setMaterialContractId(contract.getId());
                item.setChangeId(contractChangeVO.getId());
            });
        }
        saveEntity = (ContractChangeEntity)((Object)BeanMapper.map((Object)contractChangeVO, ContractChangeEntity.class));
        if (null != dbEntity) {
            saveEntity.setCreateTime(dbEntity.getCreateTime());
            saveEntity.setCreateUserCode(dbEntity.getCreateUserCode());
            saveEntity.setCreateUserName(dbEntity.getCreateUserName());
            saveEntity.setModifyUserName(userContext.getUserName());
        }
        super.saveOrUpdate((Object)saveEntity, false);
        contract.setChangingMny(contractChangeVO.getAmountWithoutTax());
        contract.setChangingTaxMny(contractChangeVO.getAmountWithTax());
        contract.setChangeCode(saveEntity.getCode());
        this.materialContractService.saveOrUpdate((Object)contract, false);
        return (ContractChangeVO)BeanMapper.map((Object)((Object)saveEntity), ContractChangeVO.class);
    }

    @Override
    public void deleteById(Long id, boolean b) {
        ContractChangeEntity e = (ContractChangeEntity)((Object)super.selectById((Serializable)id));
        if (!BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(e.getBillState()) && !BillStateEnum.UNAPPROVED.getBillStateCode().equals(e.getBillState())) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u53ea\u80fd\u5220\u9664\u81ea\u7531\u6001/\u5ba1\u6279\u9a73\u56de\u7684\u53d8\u66f4\u6570\u636e\uff01");
        }
        Integer changeState = MaterialContractVO.CONTRACT_CHANGE_STATE_UNCHANGED;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("material_contract_id", new Parameter("eq", (Object)e.getMaterialContractId()));
        List changeRecords = this.contractRecordService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)changeRecords)) {
            changeState = MaterialContractVO.CONTRACT_CHANGE_STATE_CHANGED;
        }
        MaterialContractEntity contract = (MaterialContractEntity)((Object)this.materialContractService.selectById(e.getMaterialContractId()));
        contract.setChangeBillState(null);
        contract.setChangeState(changeState);
        contract.setChangingMny(null);
        contract.setChangingTaxMny(null);
        contract.setChangeId(null);
        contract.setChangeCode(null);
        this.materialContractService.saveOrUpdate((Object)contract, false);
        super.removeById((Serializable)id, false);
    }
}

