/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.material.bean.InstoreEntity;
import com.ejianc.business.material.bean.InstoreMaterialEntity;
import com.ejianc.business.material.pub.MaterialStoreState;
import com.ejianc.business.material.service.IInstoreService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pickReturn")
public class PickReturnBpmService
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IInstoreService iInstoreService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICostDetailApi iCostDetailApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        InstoreEntity entity = (InstoreEntity)((Object)this.iInstoreService.selectById(billId));
        if (entity == null) {
            CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u5165\u5e93\u5355\uff01");
        }
        if (!ListUtil.isEmpty(entity.getInstoreMaterialList())) {
            for (InstoreMaterialEntity sub : entity.getInstoreMaterialList()) {
                sub.setStoreState(MaterialStoreState.STORED.getCode());
            }
        }
        this.processCostState(entity, 1);
        this.iInstoreService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse response = this.iCostDetailApi.checkShareFlag(billId);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp;
        InstoreEntity entity = (InstoreEntity)((Object)this.iInstoreService.selectById(billId));
        if (entity == null) {
            CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u5165\u5e93\u5355\uff01");
        }
        if (!(resp = this.billTypeApi.checkQuote(billTypeCode, billId)).isSuccess()) {
            this.logger.info("\u9886\u6599\u9000\u5e93\u5355\u636e\u3010billId-{}\u3011,\u3010billTypeCode-{}\u3011\u6267\u884c\u64a4\u56de\u64cd\u4f5c\u6821\u9a8c\u7ed3\u675f\uff0c\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u539f\u56e0\uff1a{}", new Object[]{billId, billTypeCode, resp.getMsg()});
            return CommonResponse.error((String)resp.getMsg());
        }
        if (!ListUtil.isEmpty(entity.getInstoreMaterialList())) {
            for (InstoreMaterialEntity sub : entity.getInstoreMaterialList()) {
                sub.setStoreState(MaterialStoreState.STORING.getCode());
            }
        }
        this.processCostState(entity, 0);
        this.iInstoreService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public void processCostState(InstoreEntity entity, Integer process) {
        if (process == 1) {
            this.iInstoreService.processCost(entity);
        } else {
            this.iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }
}

