/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.material.bean.OutStoreEntity;
import com.ejianc.business.material.bean.OutStoreSubEntity;
import com.ejianc.business.material.mapper.InstoreBillMaterialMapper;
import com.ejianc.business.material.mapper.MaterialContractMapper;
import com.ejianc.business.material.mapper.OutStoreMapper;
import com.ejianc.business.material.mapper.OutStoreSubMapper;
import com.ejianc.business.material.pub.MaterialStoreType;
import com.ejianc.business.material.service.IOutStoreService;
import com.ejianc.business.material.service.IPickRegisterService;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.material.vo.OutStoreSubVO;
import com.ejianc.business.material.vo.OutStoreVO;
import com.ejianc.business.material.vo.ParamsCheckDsVO;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.material.vo.PickRegisterDetailVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutStoreService
extends BaseServiceImpl<OutStoreMapper, OutStoreEntity>
implements IOutStoreService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi iCostDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private OutStoreSubMapper outStoreSubMapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static String PARAM_PLAN_COUNT = "P-72Q53Y26";
    @Autowired
    private MaterialContractMapper materialContractMapper;
    @Autowired
    private InstoreBillMaterialMapper instoreBillMaterialMapper;
    private static String PARAM_LABOR_LIMIT_COUNT = "P-29E6rb74";
    @Autowired
    private IPickRegisterService pickRegisterService;

    @Override
    public IPage<OutStoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), OutStoreVO.class));
        }
        return voPage;
    }

    @Override
    public void processCost(OutStoreEntity entity) {
        String factor = "1";
        if (ListUtil.isNotEmpty(entity.getOutStoreSubEntities())) {
            ArrayList<CostDetailVO> list = new ArrayList<CostDetailVO>();
            boolean canPush = true;
            for (int i = 0; i < entity.getOutStoreSubEntities().size(); ++i) {
                OutStoreSubEntity sub = entity.getOutStoreSubEntities().get(i);
                if (null == sub.getSubjectId()) {
                    canPush = false;
                }
                CostDetailVO c = new CostDetailVO();
                c.setSubjectId(sub.getSubjectId());
                c.setSourceId(entity.getId());
                c.setSourceDetailId(sub.getId());
                c.setProjectId(entity.getProjectId());
                c.setHappenTaxMny(sub.getAmount() == null ? new BigDecimal("0.00") : sub.getAmount().multiply(new BigDecimal(factor)));
                if (sub.getAmount() == null) {
                    c.setHappenMny(new BigDecimal("0.00"));
                } else {
                    BigDecimal rate = sub.getTaxRate() == null ? new BigDecimal("1.00") : new BigDecimal("1.00").add(sub.getTaxRate().divide(new BigDecimal("100.00"), 8, 4));
                    BigDecimal happenMny = sub.getAmount().divide(rate, 8, 4).multiply(new BigDecimal(factor));
                    c.setHappenMny(happenMny);
                }
                c.setHappenDate(entity.getOutDate());
                c.setMemo(entity.getMemo());
                c.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                c.setSourceType(MaterialStoreType.getEnumNameByCode((Integer)entity.getStoreType()));
                c.setSourceTabType(MaterialStoreType.getEnumNameByCode((Integer)entity.getStoreType()) + "_DETAIL");
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate outDate = entity.getOutDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                c.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
                c.setCostTypeName(CostTypeEnum.MATERIAL_COST_TYPE.getName());
                c.setPeriod(outDate.format(df));
                c.setShareFlag(Integer.valueOf(0));
                c.setSourceBillCode(entity.getBillCode());
                if (Objects.equals(MaterialStoreType.PICKING_OUT_STORE.getCode(), sub.getStoreType())) {
                    c.setSourceBillName(MaterialStoreType.PICKING_OUT_STORE.getDescription());
                    c.setSourceBillUrl("/ejc-material-frontend/#/pickingOut/card?id=" + entity.getId());
                }
                c.setNum(sub.getOutStoreNumber() == null ? BigDecimal.ZERO : sub.getOutStoreNumber());
                c.setMaterialId(sub.getMaterialId());
                c.setMaterialName(sub.getMaterialName());
                c.setMaterialTypeId(sub.getMaterialCategoryId());
                c.setMaterialTypeName(sub.getMaterialCategoryName());
                c.setUnit(sub.getMaterialUnit());
                c.setSpec(sub.getMaterialSpec());
                list.add(c);
            }
            CommonResponse response = this.iCostDetailApi.saveSubject(list);
            this.logger.info("\u63a8\u9001\u6210\u672c" + MaterialStoreType.getStoreTypeNameByCode((Integer)entity.getStoreType()) + "\u7ed3\u679c:" + response.isSuccess() + " msg:" + response.getMsg() + " billId=" + entity.getId());
            entity.setRelationFlag(canPush ? "1" : "0");
        } else {
            this.iCostDetailApi.deleteSubject(entity.getId());
            entity.setRelationFlag("0");
        }
    }

    @Override
    public CommonResponse<List<JSONObject>> queryMaterialCostTopN(Integer topN, Integer type) {
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        String startDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.beginOfYear((Date)new Date()));
        startDate = "'" + startDate + "'";
        List<OutStoreSubVO> outStoreSubEntities = this.outStoreSubMapper.queryMaterialCategoryCostTopN(topN, type, startDate, orgIds);
        ArrayList result = new ArrayList();
        this.logger.info("\u67e5\u8be2\u7269\u8d44\u5f00\u7d2f\u5e74\u7d2f\u6d88\u8017top n outStoreSubEntities \u6570\u91cf\uff1a" + (ListUtil.isNotEmpty(outStoreSubEntities) ? Integer.valueOf(outStoreSubEntities.size()) : "\u7a7a") + " \u5f53\u524dorgId\uff1a" + InvocationInfoProxy.getOrgId());
        if (ListUtil.isNotEmpty(outStoreSubEntities)) {
            outStoreSubEntities.forEach(en -> {
                JSONObject object = new JSONObject();
                object.put("materialCategoryName", (Object)en.getMaterialCategoryName());
                object.put("outStoreNumber", (Object)en.getOutStoreNumber());
                object.put("amount", (Object)en.getAmount());
                object.put("weight", (Object)(ComputeUtil.safeMultiply((BigDecimal)en.getUnitPrice(), (BigDecimal)new BigDecimal("100")).setScale(0, 4) + "%"));
                result.add(object);
            });
        }
        return CommonResponse.success(result);
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public ParamsCheckVO checkParams(MaterialPriceVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap paramsCheckVOMap = new HashMap();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType(paramsArray[0]);
        List<MaterialPriceVO> detailList = vo.getDetail();
        Integer instoreType = vo.getInstoreType();
        if (CollectionUtils.isNotEmpty((Collection)detailList) && (int)detailList.stream().filter(in -> in.getMaterialId() != null).count() > 0) {
            detailList = detailList.stream().filter(in -> in.getMaterialId() != null).collect(Collectors.toList());
            HashMap<Long, MaterialPriceVO> thisMap = new HashMap<Long, MaterialPriceVO>();
            detailList.forEach(item -> {
                if (thisMap.containsKey(item.getMaterialId())) {
                    MaterialPriceVO materialPriceVO = (MaterialPriceVO)thisMap.get(item.getMaterialId());
                    materialPriceVO.setNum(ComputeUtil.nullToZero((BigDecimal)ComputeUtil.safeAdd((BigDecimal)materialPriceVO.getNum(), (BigDecimal)item.getNum())));
                } else {
                    thisMap.put(item.getMaterialId(), (MaterialPriceVO)item);
                }
            });
            ArrayList<Long> materialIds = new ArrayList<Long>(thisMap.keySet());
            Long projectId = vo.getProjectId();
            Long supplierId = vo.getLabourArmyId();
            if (instoreType != null && instoreType == 5 && supplierId != null) {
                CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_LIMIT_COUNT, curOrgId);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u52b3\u52a1\u961f\u4f0d\u9886\u6599\u9650\u989d\u91cf\u63a7\u5236\u6750\u6599\u51fa\u5e93\u91cf\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                }
                List billParamVOS = (List)response.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                    Map<Long, BigDecimal> planMap = this.pickRegisterService.queryLaborLimitMaterialCount(projectId, supplierId, materialIds);
                    List<MaterialPriceVO> vos = ((OutStoreMapper)this.baseMapper).queryLaborMaterialCount(vo.getId(), projectId, supplierId, materialIds);
                    HashMap numVOMap = CollectionUtils.isEmpty(vos) ? new HashMap() : vos.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, MaterialPriceVO::getNum));
                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal divide = roleValue.divide(BigDecimal.valueOf(100L));
                        thisMap.forEach((k, d) -> {
                            BigDecimal _applyNum;
                            BigDecimal num = d.getNum();
                            BigDecimal applyNum = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)planMap.get(d.getMaterialId())));
                            BigDecimal hasNum = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)numVOMap.get(d.getMaterialId())));
                            BigDecimal allNum = ComputeUtil.safeAdd((BigDecimal)hasNum, (BigDecimal)num);
                            if (allNum.compareTo(_applyNum = applyNum.multiply(divide)) > 0) {
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO(d.getMaterialId(), "outStoreNumber");
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem(d.getMaterialName() + (StringUtils.isNotEmpty((CharSequence)d.getSpec()) ? " [" + d.getSpec() + "]" : ""));
                                paramsCheckDsVO.setWarnName("\u52b3\u52a1\u961f\u4f0d\u9886\u6599\u51fa\u5e93\u91cf\u5927\u4e8e\u9886\u6599\u9650\u989d\u91cf");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("\u8be5\u6750\u6599\u672c\u6b21\u51fa\u5e93\u6570\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u51fa\u5e93\u6570\u91cf\uff1a").append(allNum.setScale(2, 4)).append("\uff0c\u9886\u6599\u9650\u989d\u6570\u91cf*").append(roleValue).append("%: ").append(_applyNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)allNum, (BigDecimal)_applyNum).setScale(2, 4));
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                OutStoreService.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        });
                    }
                }
            }
        }
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    @Override
    public List<PickRegisterDetailVO> queryPickDeductList(Page<PickRegisterDetailVO> page, QueryWrapper wrapper, Long projectId, Long supplierId) {
        return ((OutStoreMapper)this.baseMapper).queryPickDeductList(page, wrapper, projectId, supplierId);
    }

    @Override
    public boolean codeCheck(Long id, String code) {
        QueryParam check = new QueryParam();
        if (id != null) {
            check.getParams().put("id", new Parameter("ne", (Object)id));
        }
        check.getParams().put("bill_code", new Parameter("eq", (Object)code));
        check.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(check, false);
        return !CollectionUtils.isNotEmpty((Collection)entityList);
    }

    @Override
    public List<MaterialPriceVO> queryLaborMaterialCount(Long id, Long projectId, Long supplierId, List<Long> materialIds) {
        return ((OutStoreMapper)this.baseMapper).queryLaborMaterialCount(id, projectId, supplierId, materialIds);
    }

    @Override
    public CommonResponse<List<Map<String, Object>>> queryMaterialNumTopN(Integer topN, List<Long> orgIdList, List<Long> sectionIds) {
        List<Map<String, Object>> outStoreSubEntities = this.outStoreSubMapper.queryMaterialNumTopN(topN, orgIdList, sectionIds);
        return CommonResponse.success(outStoreSubEntities);
    }
}

