/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.mdm.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.vo.DataModelItemVO;
import com.ejianc.foundation.mdm.vo.DataModelVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.http.Header;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.http.HttpResponseHandler;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datamodel/"})
public class DataModelController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IDataModelService dataModelService;
    @Autowired
    private IDataModelItemService dataModelItemService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DataModelVO> saveOrUpdate(@RequestBody DataModelVO dataModelVo) {
        return this.dataModelService.saveOrUpdate(dataModelVo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DataModelVO> queryDetail(@RequestParam Long id) {
        DataModelVO dataModelVo = this.dataModelService.queryDetail(id);
        return CommonResponse.success((Object)dataModelVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        return this.dataModelService.delete(id);
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DataModelEntity>> pageList(@RequestBody QueryParam queryParam) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getOrderMap().put("sequence", "asc");
        IPage<DataModelEntity> pageData = this.dataModelService.queryDataModelPage(queryParam);
        return CommonResponse.success(pageData);
    }

    @RequestMapping(value={"/queryChildren"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DataModelEntity>> queryChildren(@RequestParam Long dataModelId) {
        List<DataModelEntity> dataModelEntities = this.dataModelService.queryChildren(dataModelId);
        return CommonResponse.success(dataModelEntities);
    }

    @RequestMapping(value={"/publish"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> publishDataModel(@RequestParam Long dataModelId) {
        this.dataModelService.publishDataModel(dataModelId);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DataModelVO>> queryTree() {
        List entitys = this.dataModelService.list();
        List dataList = BeanMapper.mapList((Iterable)entitys, DataModelVO.class);
        List<DataModelVO> vos = DataModelController.createTreeDataVO(dataList);
        return CommonResponse.success(vos);
    }

    @RequestMapping(value={"/queryItems"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryItems(@RequestParam Long id) {
        DataModelVO dataModelVo = this.dataModelService.queryDetail(id);
        JSONObject json = new JSONObject();
        if (dataModelVo != null) {
            json.put("dataModelCode", (Object)dataModelVo.getModelCode());
            if (dataModelVo.getDataModelItemVos() != null && dataModelVo.getDataModelItemVos().size() > 0) {
                JSONObject items = new JSONObject();
                dataModelVo.getDataModelItemVos().forEach(e -> items.put(e.getItemCode(), (Object)e.getItemName()));
                json.put("items", (Object)items);
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"parent_id", (Object)id);
            List dataList = this.dataModelService.list((Wrapper)queryWrapper);
            if (dataList != null && dataList.size() > 0) {
                JSONArray array = new JSONArray();
                for (DataModelEntity entity : dataList) {
                    JSONObject children = new JSONObject();
                    children.put("dataModelCode", (Object)entity.getModelCode());
                    QueryWrapper itemQueryWrapper = new QueryWrapper();
                    itemQueryWrapper.eq((Object)"data_model_id", (Object)entity.getId());
                    itemQueryWrapper.orderByAsc((Object)"sequence");
                    List itemEntities = this.dataModelItemService.list((Wrapper)itemQueryWrapper);
                    if (itemEntities != null && itemEntities.size() > 0) {
                        JSONObject items = new JSONObject();
                        itemEntities.forEach(e -> items.put(e.getItemCode(), (Object)e.getItemName()));
                        children.put("items", (Object)items);
                    }
                    array.add((Object)children);
                }
                json.put("children", (Object)array);
            }
        }
        return CommonResponse.success((Object)json);
    }

    public static List<DataModelVO> createTreeDataVO(List<DataModelVO> list) {
        ArrayList<DataModelVO> resp = new ArrayList<DataModelVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, DataModelVO> listMap = new HashMap<String, DataModelVO>();
        for (DataModelVO orgEntity : list) {
            orgEntity.setKey(orgEntity.getId());
            listMap.put(orgEntity.getId().toString(), orgEntity);
        }
        for (int i = 0; i < list.size(); ++i) {
            DataModelVO orgEntity;
            orgEntity = list.get(i);
            String parentId = orgEntity.getParentId() != null && orgEntity.getParentId() > 0L ? orgEntity.getParentId().toString() : "";
            DataModelVO parent = (DataModelVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(orgEntity);
                    continue;
                }
                ArrayList<DataModelVO> children = new ArrayList<DataModelVO>();
                children.add(orgEntity);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(orgEntity.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((DataModelVO)listMap.get(rootId));
        }
        return resp;
    }

    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO refer = new ReferVO();
        ArrayList<ReferShowfieldVO> gridHeaders = new ArrayList<ReferShowfieldVO>();
        ReferShowfieldVO idHeader = new ReferShowfieldVO();
        ReferShowfieldVO nameHeader = new ReferShowfieldVO();
        ReferShowfieldVO codeHeader = new ReferShowfieldVO();
        switch (refCode) {
            case "dataModel": {
                refer.setRefCode("dataModel");
                refer.setRefName("\u6570\u636e\u6a21\u578b");
                refer.setRefType("grid");
                refer.setDataurl(this.baseHost + "ejc-mdm-web/datamodel/queryDataModelReferList");
                refer.setIdField("id");
                refer.setCodeField("modelCode");
                refer.setNameField("modelName");
                refer.setId(Long.valueOf(23332323L));
                idHeader.setId(Long.valueOf(1L));
                idHeader.setName("\u4e3b\u952e");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder(Integer.valueOf(1));
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                codeHeader.setId(Long.valueOf(2L));
                codeHeader.setName("\u6570\u636e\u6a21\u578b\u7f16\u7801");
                codeHeader.setCode("modelCode");
                codeHeader.setHidden(false);
                codeHeader.setShowOrder(Integer.valueOf(2));
                codeHeader.setType("string");
                gridHeaders.add(codeHeader);
                nameHeader.setId(Long.valueOf(3L));
                nameHeader.setName("\u6570\u636e\u6a21\u578b\u540d\u79f0");
                nameHeader.setCode("modelName");
                nameHeader.setHidden(false);
                nameHeader.setShowOrder(Integer.valueOf(3));
                nameHeader.setType("string");
                gridHeaders.add(nameHeader);
                refer.setGridheaders(gridHeaders);
                break;
            }
            case "dataModelItem": {
                refer.setRefCode("dataModelItem");
                refer.setRefName("\u6570\u636e\u6a21\u578b\u5b57\u6bb5");
                refer.setRefType("grid");
                refer.setDataurl(this.baseHost + "ejc-mdm-web/datamodel/queryDataModelItemReferList");
                refer.setIdField("id");
                refer.setCodeField("itemCode");
                refer.setNameField("itemName");
                refer.setId(Long.valueOf(23332323L));
                idHeader.setId(Long.valueOf(1L));
                idHeader.setName("\u4e3b\u952e");
                idHeader.setCode("id");
                idHeader.setHidden(true);
                idHeader.setShowOrder(Integer.valueOf(0));
                idHeader.setType("string");
                gridHeaders.add(idHeader);
                codeHeader.setId(Long.valueOf(2L));
                codeHeader.setName("\u6a21\u578b\u5b57\u6bb5\u7f16\u7801");
                codeHeader.setCode("itemCode");
                codeHeader.setHidden(false);
                codeHeader.setShowOrder(Integer.valueOf(1));
                codeHeader.setType("string");
                gridHeaders.add(codeHeader);
                nameHeader.setId(Long.valueOf(3L));
                nameHeader.setName("\u6a21\u578b\u5b57\u6bb5\u540d\u79f0");
                nameHeader.setCode("itemName");
                nameHeader.setHidden(false);
                nameHeader.setShowOrder(Integer.valueOf(2));
                nameHeader.setType("string");
                gridHeaders.add(nameHeader);
                ReferShowfieldVO dataTypeHeader = new ReferShowfieldVO();
                dataTypeHeader.setId(Long.valueOf(4L));
                dataTypeHeader.setName("\u6570\u636e\u7c7b\u578b");
                dataTypeHeader.setCode("dataType");
                dataTypeHeader.setHidden(false);
                dataTypeHeader.setShowOrder(Integer.valueOf(3));
                dataTypeHeader.setType("string");
                gridHeaders.add(dataTypeHeader);
                refer.setGridheaders(gridHeaders);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)refer);
        return CommonResponse.success((Object)refer);
    }

    @RequestMapping(value={"/queryDataModelReferList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DataModelVO>> queryDataModelReferList(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam(required=true) int pageSize, @RequestParam(required=true) int pageNumber) {
        QueryParam queryParam = new QueryParam();
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("publishFlag", new Parameter("eq", (Object)1));
        queryParam.getParams().put("refer", new Parameter("eq", (Object)"true"));
        queryParam.getOrderMap().put("sequence", "asc");
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("modelCode");
        fuzzyFields.add("modelName");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        IPage<DataModelEntity> ePage = this.dataModelService.queryDataModelPage(queryParam);
        Page pageData = new Page(ePage.getCurrent(), ePage.getSize(), ePage.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)ePage.getRecords(), DataModelVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6a21\u578b\u5217\u8868\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDataModelItemReferList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DataModelItemVO>> queryDataModelItemReferList(@RequestParam(required=false) String condition, @RequestParam(required=false) String searchText, @RequestParam(required=true) int pageSize, @RequestParam(required=true) int pageNumber) {
        JSONObject cond;
        QueryParam queryParam = new QueryParam();
        if (condition != null && (cond = JSONObject.parseObject((String)condition)).get((Object)"dataModelId") != null) {
            queryParam.getParams().put("dataModelId", new Parameter("eq", (Object)Long.parseLong(cond.get((Object)"dataModelId").toString())));
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("itemCode");
        fuzzyFields.add("itemName");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        IPage ePage = this.dataModelItemService.queryPage(queryParam);
        Page pageData = new Page(ePage.getCurrent(), ePage.getSize(), ePage.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)ePage.getRecords(), DataModelItemVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6a21\u578b\u5217\u8868\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/operateDataSync"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> operateDataSync(HttpServletRequest request, @RequestParam Long dataModelId) {
        DataModelEntity dataModelEntity = (DataModelEntity)((Object)this.dataModelService.getById(dataModelId));
        if (dataModelEntity != null) {
            if (StringUtils.isNotBlank((CharSequence)dataModelEntity.getSyncAddress())) {
                final String syncAddr = this.baseHost + dataModelEntity.getSyncAddress();
                this.logger.info("syncAddr=" + syncAddr);
                final String authority = request.getHeader("authority");
                this.logger.info("authority=" + authority);
                Thread syncOperate = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Header[] headers = new Header[]{new Header("authority", authority)};
                        ArrayList params = new ArrayList();
                        HttpClientUtils.getInstance().post(syncAddr, headers, params, new HttpResponseHandler(){

                            public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
                            }

                            public void onFailure(int status, byte[] data) {
                                super.onFailure(status, data);
                            }
                        });
                    }
                });
                syncOperate.run();
            } else {
                return CommonResponse.error((String)"\u540c\u6b65\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        return CommonResponse.success();
    }
}

