/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.mdm.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.mdm.bean.DataModelCategoryEntity;
import com.ejianc.foundation.mdm.bean.DataModelEntity;
import com.ejianc.foundation.mdm.bean.DataModelItemEntity;
import com.ejianc.foundation.mdm.mapper.DataModelItemMapper;
import com.ejianc.foundation.mdm.mapper.DataModelMapper;
import com.ejianc.foundation.mdm.service.IDataModelCategoryService;
import com.ejianc.foundation.mdm.service.IDataModelItemService;
import com.ejianc.foundation.mdm.service.IDataModelService;
import com.ejianc.foundation.mdm.vo.DataModelItemVO;
import com.ejianc.foundation.mdm.vo.DataModelVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataModelServiceImpl
extends BaseServiceImpl<DataModelMapper, DataModelEntity>
implements IDataModelService {
    @Autowired
    private IDataModelItemService dataModelItemService;
    @Autowired
    private IDataModelCategoryService dataModelCategoryService;
    @Autowired
    private DataModelMapper dataModelMapper;
    @Autowired
    private DataModelItemMapper dataModelItemMapper;

    @Override
    public CommonResponse<DataModelVO> saveOrUpdate(DataModelVO dataModelVo) {
        List dataModelEntities;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"model_code", (Object)dataModelVo.getModelCode());
        DataModelEntity dataModelEntity = null;
        String operateMessage = "";
        if (dataModelVo.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)dataModelVo.getId());
            dataModelEntities = ((DataModelMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            if (dataModelEntities != null && dataModelEntities.size() > 0) {
                return CommonResponse.error((String)"\u6570\u636e\u6a21\u578b\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
            }
            dataModelEntity = (DataModelEntity)((Object)super.getById((Serializable)dataModelVo.getId()));
            dataModelEntity.setModelCode(dataModelVo.getModelCode());
            dataModelEntity.setModelName(dataModelVo.getModelName());
            dataModelEntity.setSyncAddress(dataModelVo.getSyncAddress());
            dataModelEntity.setSequence(dataModelVo.getSequence());
            operateMessage = "\u4fee\u6539\u6210\u529f";
        } else {
            dataModelEntities = ((DataModelMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            if (dataModelEntities != null && dataModelEntities.size() > 0) {
                return CommonResponse.error((String)"\u6570\u636e\u6a21\u578b\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
            }
            dataModelEntity = (DataModelEntity)((Object)BeanMapper.map((Object)dataModelVo, DataModelEntity.class));
            dataModelEntity.setId(IdWorker.getId());
            operateMessage = "\u4fdd\u5b58\u6210\u529f";
        }
        this.saveOrUpdate((Object)dataModelEntity, false);
        List itemVos = dataModelVo.getDataModelItemVos();
        ArrayList<DataModelItemEntity> itemEntities = new ArrayList<DataModelItemEntity>();
        ArrayList<Long> delItemIds = new ArrayList<Long>();
        for (DataModelItemVO itemVo : itemVos) {
            DataModelItemEntity itemEntity;
            if (StringUtils.isNotBlank((CharSequence)itemVo.getRowState()) && "add".equals(itemVo.getRowState())) {
                itemEntity = (DataModelItemEntity)((Object)BeanMapper.map((Object)itemVo, DataModelItemEntity.class));
                itemEntity.setDataModelId(dataModelEntity.getId());
                itemEntities.add(itemEntity);
            }
            if (StringUtils.isNotBlank((CharSequence)itemVo.getRowState()) && "edit".equals(itemVo.getRowState())) {
                itemEntity = (DataModelItemEntity)((Object)BeanMapper.map((Object)itemVo, DataModelItemEntity.class));
                itemEntities.add(itemEntity);
            }
            if (!StringUtils.isNotBlank((CharSequence)itemVo.getRowState()) || !"del".equals(itemVo.getRowState())) continue;
            delItemIds.add(itemVo.getId());
        }
        DataModelVO responseVo = (DataModelVO)BeanMapper.map((Object)((Object)dataModelEntity), DataModelVO.class);
        if (itemEntities.size() > 0) {
            this.dataModelItemService.saveOrUpdateBatch(itemEntities);
            responseVo.setDataModelItemVos(BeanMapper.mapList(itemEntities, DataModelItemVO.class));
        }
        if (delItemIds.size() > 0) {
            this.dataModelItemService.removeByIds(delItemIds);
        }
        return CommonResponse.success((String)operateMessage, (Object)responseVo);
    }

    @Override
    public DataModelVO queryDetail(Long id) {
        DataModelEntity dataModelEntity = (DataModelEntity)((Object)super.getById((Serializable)id));
        if (dataModelEntity != null) {
            DataModelVO dataModelVo = (DataModelVO)BeanMapper.map((Object)((Object)dataModelEntity), DataModelVO.class);
            QueryWrapper itemQueryWrapper = new QueryWrapper();
            itemQueryWrapper.eq((Object)"data_model_id", (Object)dataModelVo.getId());
            itemQueryWrapper.orderByAsc((Object)"sequence");
            List itemEntities = this.dataModelItemService.list((Wrapper)itemQueryWrapper);
            if (itemEntities != null && itemEntities.size() > 0) {
                List itemVos = BeanMapper.mapList((Iterable)itemEntities, DataModelItemVO.class);
                dataModelVo.setDataModelItemVos(itemVos);
            }
            if (dataModelVo.getParentId() != null && dataModelVo.getParentId() > 0L) {
                DataModelItemVO parentModelItem = new DataModelItemVO();
                parentModelItem.setDataModelId(dataModelVo.getId());
                parentModelItem.setItemCode("_parent_id");
                parentModelItem.setItemName("\u7236ID");
                parentModelItem.setDataType("long");
                dataModelVo.getDataModelItemVos().add(parentModelItem);
            }
            return dataModelVo;
        }
        return null;
    }

    @Override
    public CommonResponse<String> delete(Long id) {
        QueryWrapper itemWrapper = new QueryWrapper();
        itemWrapper.eq((Object)"parent_id", (Object)id);
        List childModels = this.list((Wrapper)itemWrapper);
        if (childModels != null && childModels.size() > 0) {
            for (DataModelEntity childModel : childModels) {
                this.deleteDataModel(childModel.getId());
            }
        }
        this.deleteDataModel(id);
        return CommonResponse.success();
    }

    private void deleteDataModel(Long modelId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"data_model_id", (Object)modelId);
        this.dataModelItemService.remove((Wrapper)queryWrapper);
        this.removeById(modelId);
    }

    @Override
    public IPage<DataModelEntity> queryDataModelPage(QueryParam queryParam) {
        Page page = new Page();
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            if ("categoryId".equals(entry.getKey())) {
                DataModelCategoryEntity categoryEntity;
                Parameter parameter = (Parameter)entry.getValue();
                if (StringUtils.isBlank((CharSequence)(parameter.getValue() + "")) || (categoryEntity = (DataModelCategoryEntity)((Object)this.dataModelCategoryService.getById((Serializable)((Object)parameter.getValue().toString())))) == null) continue;
                condition.put("innerCode", categoryEntity.getInnerCode());
                continue;
            }
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("pageIndex", (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        condition.put("pageSize", queryParam.getPageSize());
        List<DataModelEntity> records = this.dataModelMapper.queryList(condition);
        if (records != null && records.size() > 0) {
            Long count = this.dataModelMapper.queryCount(condition);
            page.setCurrent((long)queryParam.getPageIndex());
            page.setSize((long)queryParam.getPageSize());
            page.setTotal(count.longValue());
            page.setRecords(records);
        }
        return page;
    }

    private String obtainColumnType(DataModelItemEntity item) {
        String dataType = item.getDataType();
        String columnSql = "";
        switch (dataType) {
            case "string": {
                columnSql = " varchar(" + item.getDataLength() + ") default null comment '" + item.getItemName() + "',";
                break;
            }
            case "integer": {
                columnSql = " int(" + item.getDataLength() + ") default null comment '" + item.getItemName() + "',";
                break;
            }
            case "long": {
                columnSql = " bigint(20) default null comment '" + item.getItemName() + "',";
                break;
            }
            case "datetime": {
                columnSql = " datetime default null comment '" + item.getItemName() + "',";
                break;
            }
            case "date": {
                columnSql = " datetime default null comment '" + item.getItemName() + "',";
                break;
            }
            case "refer": {
                columnSql = " bigint(20) default null comment '" + item.getItemName() + "',";
                break;
            }
            case "decimal": {
                columnSql = " decimal(28,8) default null comment '" + item.getItemName() + "',";
            }
        }
        return columnSql;
    }

    @Override
    public void publishDataModel(Long dataModelId) {
        this.dataModelMapper.updateDataModelState(dataModelId);
        DataModelEntity dataModelEntity = (DataModelEntity)((Object)super.getById((Serializable)dataModelId));
        QueryWrapper itemQueryWrapper = new QueryWrapper();
        itemQueryWrapper.eq((Object)"data_model_id", (Object)dataModelId);
        itemQueryWrapper.orderByAsc((Object)"sequence");
        List itemEntities = this.dataModelItemService.list((Wrapper)itemQueryWrapper);
        String createSql = "create table `" + dataModelEntity.getModelCode() + "` (";
        createSql = createSql + " _master_data_id bigint(20) not null comment '\u4e3b\u952eID',";
        createSql = createSql + " _last_update_time datetime default null comment '\u6700\u540e\u4e00\u6b21\u4fee\u6539\u65f6\u95f4',";
        createSql = createSql + " _data_type tinyint(4) default null comment '\u6570\u636e\u72b6\u6001\uff081\uff1a\u65b0\u589e\uff0c2\uff1a\u4fee\u6539\uff0c3\uff1a\u5220\u9664\uff09',";
        createSql = createSql + " _source_id varchar(100) default null comment '\u5bf9\u5e94\u4e1a\u52a1\u4e3b\u952eID',";
        createSql = createSql + " _data_state tinyint(4) default null comment '\u6570\u636e\u63a8\u9001\u72b6\u6001\uff081\uff1a\u5df2\u63a8\u9001\uff0c0\uff1a\u672a\u63a8\u9001\uff09',";
        for (DataModelItemEntity item : itemEntities) {
            createSql = createSql + " `" + item.getItemCode() + "`" + this.obtainColumnType(item);
        }
        createSql = createSql + " PRIMARY KEY (`_master_data_id`) USING BTREE )";
        createSql = createSql + " ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='" + dataModelEntity.getModelName() + "'";
        this.dataModelItemMapper.executeCreateSql(createSql);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"parent_id", (Object)dataModelId);
        List childList = this.dataModelMapper.selectList((Wrapper)queryWrapper);
        if (childList != null && childList.size() > 0) {
            for (DataModelEntity childModel : childList) {
                QueryWrapper childItemQueryWrapper = new QueryWrapper();
                childItemQueryWrapper.eq((Object)"data_model_id", (Object)childModel.getId());
                childItemQueryWrapper.orderByAsc((Object)"sequence");
                List childItemEntities = this.dataModelItemService.list((Wrapper)childItemQueryWrapper);
                createSql = "create table `" + childModel.getModelCode() + "` (";
                createSql = createSql + " _master_data_id bigint(20) not null comment '\u4e3b\u952eID',";
                createSql = createSql + " _last_update_time datetime default null comment '\u6700\u540e\u4e00\u6b21\u4fee\u6539\u65f6\u95f4',";
                createSql = createSql + " _data_type tinyint(4) default null comment '\u6570\u636e\u72b6\u6001\uff081\uff1a\u65b0\u589e\uff0c2\uff1a\u4fee\u6539\uff0c3\uff1a\u5220\u9664\uff09',";
                createSql = createSql + " _source_id varchar(100) default null comment '\u5bf9\u5e94\u4e1a\u52a1\u4e3b\u952eID', ";
                createSql = createSql + " _data_state tinyint(4) default null comment '\u6570\u636e\u63a8\u9001\u72b6\u6001\uff081\uff1a\u5df2\u63a8\u9001\uff0c0\uff1a\u672a\u63a8\u9001\uff09', ";
                createSql = createSql + " _parent_id bigint(20) default null comment '\u7236ID',";
                for (DataModelItemEntity item : childItemEntities) {
                    createSql = createSql + " `" + item.getItemCode() + "`" + this.obtainColumnType(item);
                }
                createSql = createSql + " PRIMARY KEY (`_master_data_id`) USING BTREE )";
                createSql = createSql + " ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='" + childModel.getModelName() + "'";
                this.dataModelItemMapper.executeCreateSql(createSql);
                this.dataModelMapper.updateDataModelState(childModel.getId());
            }
        }
    }

    @Override
    public List<DataModelEntity> queryChildren(Long dataModelId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"parent_id", (Object)dataModelId);
        List dataList = this.dataModelMapper.selectList((Wrapper)queryWrapper);
        if (dataList != null && dataList.size() > 0) {
            for (DataModelEntity dataModel : dataList) {
                DataModelCategoryEntity categoryEntity = (DataModelCategoryEntity)((Object)this.dataModelCategoryService.selectById(dataModel.getCategoryId()));
                dataModel.setCategoryName(categoryEntity.getCategoryName());
            }
        }
        return dataList;
    }
}

