package com.ejianc.foundation.bulidMaterialMdm.mapper;


import com.ejianc.foundation.bulidMaterialMdm.bean.*;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 筑材信息
 * 
 * @author generator
 * 
 */
@Mapper
public interface ProjectMapper extends BaseCrudMapper<MaterialProjectEntity> {
    /**
     *获取要同步的组织数据
     */
    @Select("SELECT md.* FROM `projectmodel` md\n" +
            "LEFT JOIN ejc_buildmaterial_project ma\n" +
            "on ma.mdm_id = md._master_data_id\n" +
            " where DATE_SUB(CURDATE(),INTERVAL 1 DAY) <= Date(md._last_update_time)\n" +
            " and ( ma.id is null or ma.last_update_time < md._last_update_time)")
    List<MadProjectEntity> getTodayUpdateData();

    /**
     *中间记录表新增数据
     */
    @Insert("INSERT INTO `ejc_buildmaterial_record`(mdm_id,send_time,bill_type,is_success,error_reason) VALUE(#{mdmId},#{sendTime},#{billType},#{isSuccess},#{errorReason})")
    Integer insertSendRecord(MadRecordEntity entity);

    /**
     * 根据主数据id获取筑材网id
     */
    @Select("SELECT project_id FROM `ejc_buildmaterial_project` where mdm_id = #{mdmId} limit 1")
    Integer getMaterialIdByMdmId(Long mdmId);

    /**
     *组织中间表新增数据
     */
    @Insert("INSERT INTO `ejc_buildmaterial_project`(mdm_id,project_id,last_update_time,data_type,project_name,address_str,description,owners_str,project_code) " +
            "VALUE(#{mdmId},#{projectId},#{lastUpdateTime},#{dataType},#{projectName},#{addressStr},#{description},#{ownersStr},#{projectCode})")
    Integer insertOrgInfo(MaterialProjectEntity entity);


    /**
     *组织中间表修改数据
     */
    @Update("update `ejc_buildmaterial_project` set last_update_time = #{lastUpdateTime},project_name =#{projectName},description = #{description},owners = #{owners},data_type=#{dataType}\n" +
            "where mdm_id = #{mdmId} and project_id = #{projectId}")
    Integer updateOrgInfo(MaterialProjectEntity entity);



    /**
     *查询库中所有项目个数（删除除外）
     */
    List<MadProjectEntity> selectWithPage(Integer start);
}
