package com.ejianc.foundation.bulidMaterialMdm.service;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.bulidMaterialMdm.vo.RoleVO;
import com.ejianc.foundation.bulidMaterialMdm.vo.UserVO;

import java.util.List;

/**
 * 组织部门信息
 * 
 * @author generator
 * 
 */
public interface IUserService {
    //交接工作
    String performHandover(Integer targetUserId, Integer userId);
    //修改人员信息
    JSONObject updateUser(UserVO userVO);
    //删除人员
    JSONObject deleteUser(Integer userId);
    //查询企业所有角色
    List<RoleVO> getRoleList();
    //查询当前企业下所有人员
    List<UserVO> getAllUser();
    //根据部门id查询部门下的人员
    List<UserVO> getUsersUnderDepartment(Integer departmentId);
    //添加人员
    JSONObject addUser(UserVO userVO);
    //转移部门
    JSONObject transfer(Integer departmentId,Integer departmentIdOld, Integer userId);

    //参照
    List<UserVO> queryUserData(Page<UserVO> page, Integer departmentId);

    //同步接口首次同步
    String userInfoSyncFirst(Integer page);

    //同步接口
    String userInfoSync();
}
