package com.ejianc.foundation.bulidMaterialMdm.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bulidMaterialMdm.bean.*;
import com.ejianc.foundation.bulidMaterialMdm.mapper.OrgMapper;
import com.ejianc.foundation.bulidMaterialMdm.mapper.ProjectMapper;
import com.ejianc.foundation.bulidMaterialMdm.service.IOrgService;
import com.ejianc.foundation.bulidMaterialMdm.service.IProjectService;
import com.ejianc.foundation.bulidMaterialMdm.service.ISystemRequestService;
import com.ejianc.foundation.bulidMaterialMdm.vo.OrgVO;
import com.ejianc.foundation.bulidMaterialMdm.vo.ProjectVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 组织部门信息
 *
 * @author generator
 *
 */
@Service("projectService")
public class ProjectService implements IProjectService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISystemRequestService requestService;

    @Autowired
    private ProjectMapper mapper;
    @Autowired
    private OrgMapper orgMapper;

    @Override
    public JSONObject insertProjectInfo(ProjectVO projectVO) {
        if (projectVO.getDescription() == null){
            throw new BusinessException("项目描述不允许为空！" );
        }
        if (projectVO.getName() == null){
            throw new BusinessException("项目名称不允许为空！" );
        }

        JSONObject param = JSONObject.parseObject(JSONObject.toJSONString(projectVO));

        String responseBody = requestService.sendPostRequest("project/add", param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);


        Integer code = jsonObject.getInteger("code");
        if (code == 0){
            message = jsonObject.getInteger("object")+"";
        }else {
             message = jsonObject.getString("message");
        }

        return jsonObject;
    }

    @Override
    public JSONObject updateProjectInfo( ProjectVO projectVO) {
        if (projectVO.getDescription() == null){
            throw new BusinessException("项目描述不允许为空！" );
        }
        if (projectVO.getName() == null){
            throw new BusinessException("项目名称不允许为空！" );
        }
        if (projectVO.getProjectId() == null){
            throw new BusinessException("项目id不允许为空！" );
        }

        JSONObject param = JSONObject.parseObject(JSONObject.toJSONString(projectVO));

        String responseBody = requestService.sendPostRequest("project/update", param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);


        Integer code = jsonObject.getInteger("code");
        if (code == 0){
            message = jsonObject.getInteger("object")+"";
        }else {
            message = jsonObject.getString("message");
        }
        return jsonObject;
    }
    @Override
    public List<ProjectVO> selectProjectInfo() {
        String url = "project/list";
        JSONObject param = new JSONObject();
        String responseBody = requestService.sendPostRequest(url,param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
        Integer code = jsonObject.getInteger("code");
        List<ProjectVO> orgVO = null;
        if (code == 0){
            logger.info(jsonObject.getString("object"));
            orgVO = JSONObject.parseArray(jsonObject.getString("object"), ProjectVO.class);
        }else {
            message = jsonObject.getString("message");
            throw new BusinessException("返回数据异常！"+message );
        }
        return orgVO;
    }

    @Override
    public ProjectVO selectProjectInfoById(Integer departmentId) {
        String url = "project/getProject";
//        if (departmentId != null){
//            url = url+"?departmentId="+departmentId;
//        }
        JSONObject param = new JSONObject();
        if (departmentId != null){
            param.put("projectId",departmentId);
        }
        String responseBody = requestService.sendPostRequest(url,param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
        Integer code = jsonObject.getInteger("code");
        ProjectVO orgVO = null;
        if (code == 0){
             orgVO = JSONObject.parseObject(jsonObject.getString("object"), ProjectVO.class);
        }else {
            message = jsonObject.getString("message");
            throw new BusinessException("返回数据异常！"+message );
        }
        return orgVO;
    }

    @Override
    public JSONObject deleteProjectInfo(Integer departmentId) {
        if (departmentId == null){
            throw new BusinessException("部门id不允许为空！" );
        }
        JSONObject param = new JSONObject();
        if (departmentId != null){
            param.put("departmentId",departmentId);
        }
        String responseBody = requestService.sendPostRequest("department/delete/",param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
        Integer code = jsonObject.getInteger("code");
        if (code == 0){
            message = jsonObject.getString("object")+"";
        }else {
            message = jsonObject.getString("message");
        }
        return jsonObject;
    }


    /**
     * 组织同步接口（首次同步）
     * @return
     */
    @Override
    public String projectInfoSyncFirst() {
        logger.info("筑材网同步项目信息开始---------------->");
        int page = 0;
        boolean flag =true;
        while (flag) {
            List<MadProjectEntity> todayUpdateData = mapper.selectWithPage(page * 100);
            logger.info("本次同步项目共{}个---------------->", todayUpdateData.size());
            if (todayUpdateData != null  && todayUpdateData.size() > 0) {
                for (MadProjectEntity todayUpdateDatum : todayUpdateData) {
                        //从组织表中获取筑材网对应组织id
                        Integer materialIdByMdmId = orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                        if (materialIdByMdmId != null) {
                            //进行插入操作
                            //logger.info("筑材网项目信息新增，id：{}", todayUpdateDatum.getMasterDataId());
                            ProjectVO projectVO = new ProjectVO();
                            projectVO.setDescription(todayUpdateDatum.getName());
                            projectVO.setName(todayUpdateDatum.getName());
                            projectVO.setOwners(Arrays.asList(materialIdByMdmId + ""));
                            projectVO.setAddress(Arrays.asList("河南", "郑州市", "尚贤街"));
                            JSONObject jsonObject = insertProjectInfo(projectVO);
                            //判断操作结果
                            Integer code = jsonObject.getInteger("code");
                            if (code == 0) {//筑材网新增成功
                                logger.info("筑材网新增成功，id：{}", todayUpdateDatum.getMasterDataId());
                                Integer materialId = jsonObject.getInteger("object");//筑材网返回id
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增项目", 1, "");
                                mapper.insertSendRecord(entity);
                                //组织中间表新增
                                MaterialProjectEntity materialOrgEntity = new MaterialProjectEntity();
                                materialOrgEntity.setMdmId(todayUpdateDatum.getMasterDataId());
                                materialOrgEntity.setProjectId(materialId);
                                materialOrgEntity.setDataType(1);
                                materialOrgEntity.setProjectName(todayUpdateDatum.getName());
                                materialOrgEntity.setAddressStr("");
                                materialOrgEntity.setDescription(todayUpdateDatum.getName());
                                materialOrgEntity.setOwnersStr(materialIdByMdmId + "");
                                materialOrgEntity.setLastUpdateTime(new Date());

                                mapper.insertOrgInfo(materialOrgEntity);
                            } else {
                                String message = jsonObject.getString("message");
                                logger.info("筑材网新增失败，message：{}",message);
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增项目", 2, message);
                                mapper.insertSendRecord(entity);
                            }
                        } else {
                            logger.error("筑材网项目新增父级组织不存在，上级组织名称：{},项目主数据id:{}", todayUpdateDatum.getOrgname(), todayUpdateDatum.getMasterDataId());
                        }

                    try {
                        Thread.sleep(250); // 暂停0.25秒
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }else {
                flag = false;
            }
            page++;
        }
        return "同步成功！";
    }

    /**
     * 组织同步接口
     * @return
     */
    @Override
    public String projectInfoSync() {
        logger.info("筑材网同步项目信息开始---------------->");
        /**
         * 1. 获取今天修改的组织信息
         * 2. 判断是新增还是删除还是修改
         * 3.   分别执行对应操作，插入执行记录
         *      新增：
         *      删除：
         *      修改：
         * 4.
         * 5.
         */
        //1
        List<MadProjectEntity> todayUpdateData = mapper.getTodayUpdateData();
        logger.info("本次同步项目共{}个---------------->",todayUpdateData.size());
        if (todayUpdateData != null){
            for (MadProjectEntity todayUpdateDatum : todayUpdateData) {
                    //2
                    if (todayUpdateDatum.getDataType() == 1) {//新增
                        //从组织表中获取筑材网对应组织id
                        Integer materialIdByMdmId = orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                        if (materialIdByMdmId != null) {
                            //进行插入操作
                            logger.info("筑材网项目信息新增，id：{}", todayUpdateDatum.getMasterDataId());
                            ProjectVO projectVO = new ProjectVO();
                            projectVO.setDescription(todayUpdateDatum.getName());
                            projectVO.setName(todayUpdateDatum.getName());
                            projectVO.setOwners(Arrays.asList(materialIdByMdmId + ""));
                            projectVO.setAddress(Arrays.asList("河南","郑州市","尚贤街"));
                            JSONObject jsonObject = insertProjectInfo(projectVO);
                            //判断操作结果
                            Integer code = jsonObject.getInteger("code");
                            if (code == 0) {//筑材网新增成功
                                Integer materialId = jsonObject.getInteger("object");//筑材网返回id
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增项目", 1, "");
                                mapper.insertSendRecord(entity);
                                //组织中间表新增
                                MaterialProjectEntity materialOrgEntity = new MaterialProjectEntity();
                                materialOrgEntity.setMdmId(todayUpdateDatum.getMasterDataId());
                                materialOrgEntity.setProjectId(materialId);
                                materialOrgEntity.setDataType(1);
                                materialOrgEntity.setProjectName(todayUpdateDatum.getName());
                                materialOrgEntity.setAddressStr("");
                                materialOrgEntity.setDescription(todayUpdateDatum.getName());
                                materialOrgEntity.setOwnersStr(materialIdByMdmId + "");
                                materialOrgEntity.setLastUpdateTime(new Date());

                                mapper.insertOrgInfo(materialOrgEntity);
                            } else {
                                String message = jsonObject.getString("message");
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增项目", 2, message);
                                mapper.insertSendRecord(entity);
                            }
                        }else {
                            logger.error("筑材网项目新增父级组织不存在，上级组织名称：{},项目主数据id:{}", todayUpdateDatum.getOrgname(),todayUpdateDatum.getMasterDataId());
                        }
                    } else if (todayUpdateDatum.getDataType() == 2) {//修改
                        //从组织表中获取筑材网对应组织id
                        Integer materialIdByMdmId = orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                        if (materialIdByMdmId != null) {
                            Integer materialProjectId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getMasterDataId());
                            if (materialProjectId != null) {
                                //项目中间表中存在这个项目的数据
                                //进行修改操作
                                logger.info("筑材网项目信息修改，id：{}", todayUpdateDatum.getMasterDataId());
                                ProjectVO projectVO = new ProjectVO();
                                projectVO.setDescription(todayUpdateDatum.getName());
                                projectVO.setName(todayUpdateDatum.getName());
                                projectVO.setOwners(Arrays.asList(materialIdByMdmId + ""));
                                projectVO.setProjectId(materialProjectId);

                                JSONObject jsonObject = updateProjectInfo(projectVO);
                                //判断操作结果
                                Integer code = jsonObject.getInteger("code");
                                if (code == 0) {//筑材网修改成功
                                    //记录表新增
                                    MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改项目", 1, "");
                                    mapper.insertSendRecord(entity);
                                    //组织中间表新增
                                    MaterialProjectEntity materialOrgEntity = new MaterialProjectEntity();
                                    materialOrgEntity.setMdmId(todayUpdateDatum.getMasterDataId());
                                    materialOrgEntity.setProjectId(materialProjectId);
                                    materialOrgEntity.setDataType(2);
                                    materialOrgEntity.setProjectName(todayUpdateDatum.getName());
                                    materialOrgEntity.setDescription(todayUpdateDatum.getName());
                                    materialOrgEntity.setOwnersStr(materialIdByMdmId + "");
                                    materialOrgEntity.setLastUpdateTime(new Date());

                                    mapper.updateOrgInfo(materialOrgEntity);
                                } else {
                                    String message = jsonObject.getString("message");
                                    //记录表新增
                                    MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改项目", 2, message);
                                    mapper.insertSendRecord(entity);
                                }
                            }else {//项目中间表中不存在这个项目的数据，走新增逻辑
                                //进行插入操作
                                logger.info("筑材网项目信息修改新增，id：{}", todayUpdateDatum.getMasterDataId());
                                ProjectVO projectVO = new ProjectVO();
                                projectVO.setDescription(todayUpdateDatum.getName());
                                projectVO.setName(todayUpdateDatum.getName());
                                projectVO.setOwners(Arrays.asList(materialIdByMdmId + ""));
                                projectVO.setAddress(Arrays.asList("河南","郑州市","尚贤街"));
                                JSONObject jsonObject = insertProjectInfo(projectVO);
                                //判断操作结果
                                Integer code = jsonObject.getInteger("code");
                                if (code == 0) {//筑材网新增成功
                                    Integer materialId = jsonObject.getInteger("object");//筑材网返回id
                                    //记录表新增
                                    MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改新增项目", 1, "");
                                    mapper.insertSendRecord(entity);
                                    //组织中间表新增
                                    MaterialProjectEntity materialOrgEntity = new MaterialProjectEntity();
                                    materialOrgEntity.setMdmId(todayUpdateDatum.getMasterDataId());
                                    materialOrgEntity.setLastUpdateTime(new Date());
                                    materialOrgEntity.setProjectId(materialId);
                                    materialOrgEntity.setDataType(1);
                                    materialOrgEntity.setProjectName(todayUpdateDatum.getName());
                                    materialOrgEntity.setAddressStr("");
                                    materialOrgEntity.setDescription(todayUpdateDatum.getName());
                                    materialOrgEntity.setOwnersStr(materialIdByMdmId + "");


                                    mapper.insertOrgInfo(materialOrgEntity);
                                } else {
                                    String message = jsonObject.getString("message");
                                    //记录表新增
                                    MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改新增项目", 2, message);
                                    mapper.insertSendRecord(entity);
                                }
                            }
                        }else {
                            logger.error("筑材网项目修改父级组织不存在，上级组织名称：{},项目主数据id:{}", todayUpdateDatum.getOrgname(),todayUpdateDatum.getMasterDataId());
                        }

                    } else if (todayUpdateDatum.getDataType() == 3) {//删除
                        //暂无删除接口
//                        //从记录表中获取筑材网对应id
//                        Integer materialId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getMasterDataId());
//                            if (materialId != null) {
//                                logger.info("筑材网组织信息删除，id：{}", todayUpdateDatum.getMasterDataId());
//
//                                //执行删除操作
//                                JSONObject jsonObject = deleteProjectInfo(materialId);
//                                //判断操作结果
//                                Integer code = jsonObject.getInteger("code");
//                                if (code == 0) {//筑材网删除成功
//                                    String object = jsonObject.getString("object");//筑材网返回信息
//                                    //记录表新增
//                                    MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "删除组织", 1, object);
//                                    mapper.insertSendRecord(entity);
//
//                                    //从记录表中获取筑材网对应父id
//                                    Integer materialparentId = null;
//                                    if (todayUpdateDatum.getParentid() != null) {
//                                        materialparentId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getParentid());
//                                    }
//                                    //组织中间表修改
//                                    MaterialOrgEntity materialOrgEntity = new MaterialOrgEntity(todayUpdateDatum.getMasterDataId(), new Date(),
//                                            materialId, 3, todayUpdateDatum.getName(), materialparentId);
//                                    mapper.updateOrgInfo(materialOrgEntity);
//
//                                } else {
//                                    String message = jsonObject.getString("message");
//                                    //记录表新增
//                                    MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "删除组织", 2, message);
//                                    mapper.insertSendRecord(entity);
//                                }
//                            }else {
//                                //记录表新增
//                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "删除组织", 2, "中间表查询数据失败！");
//                                mapper.insertSendRecord(entity);
//                            }

                }

                try {
                    Thread.sleep(500); // 暂停0.5秒
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        return null;
    }

}
