package com.ejianc.foundation.bulidMaterialMdm.controller;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bulidMaterialMdm.mapper.OrgMapper;
import com.ejianc.foundation.bulidMaterialMdm.service.IOrgService;
import com.ejianc.foundation.bulidMaterialMdm.vo.OrgVO;

import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;

/**
 * 筑材信息
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialInfo")
public class MaterialInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IOrgService service;

    @Autowired
    private OrgMapper orgMapper;


    /**
     * @Description insertOrgInfo
     * @param
     */
    @RequestMapping(value = "/insertOrgInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> insertOrgInfo(@RequestParam(required = true) String departmentName,
                                                @RequestParam(required = false) Integer parentId) {
        JSONObject s = service.insertOrgInfo(departmentName, parentId);
        return CommonResponse.success("查询详情数据成功！",s);
    }
    /**
     * @Description selectOrgInfo
     * @param
     */
    @RequestMapping(value = "/selectOrgInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgVO> selectOrgInfo(@RequestParam(required = false) Integer departmentId) {
        OrgVO orgVO = service.selectOrgInfo(departmentId);
        return CommonResponse.success("查询详情数据成功！",orgVO);
    }
    /**
     * @Description updateOrgInfo
     * @param
     */
    @RequestMapping(value = "/updateOrgInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> updateOrgInfo(@RequestParam(required = true) Integer departmentId,
                                                @RequestParam(required = true) String departmentName,
                                                @RequestParam(required = false) Integer parentId) {
        JSONObject s = service.updateOrgInfo(departmentId, departmentName, parentId);
        return CommonResponse.success("查询详情数据成功！",s);
    }
    /**
     * @Description deleteOrgInfo
     * @param
     */
    @RequestMapping(value = "/deleteOrgInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> deleteOrgInfo(@RequestParam(required = true) Integer departmentId) {
        JSONObject s = service.deleteOrgInfo(departmentId);
        return CommonResponse.success("查询详情数据成功！",s);
    }


    /**
     * @Description  组织同步接口
     * @param
     * @Return
     */
    @RequestMapping(value = "/orgInfoSyncFirst", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> orgInfoSyncFirst(HttpServletRequest request) {
        String s = service.orgInfoSyncFirst();
        return CommonResponse.success("执行成功！");
    }
    /**
     * @Description  组织同步接口
     * @param
     * @Return
     */
    @RequestMapping(value = "/orgInfoSync", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> orgInfoSync(HttpServletRequest request) {
        String s = service.orgInfoSync();
        return CommonResponse.success("执行成功！");
    }

}
