package com.ejianc.foundation.bulidMaterialMdm.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.bulidMaterialMdm.service.IUserService;
import com.ejianc.foundation.bulidMaterialMdm.vo.RoleVO;
import com.ejianc.foundation.bulidMaterialMdm.vo.UserVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

/**
 * 筑材信息
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("user")
public class UserController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IUserService service;





    /**
     * @Description 修改人员信息
     * @param
     */
    @RequestMapping(value = "/updateUser", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> updateUser(@RequestBody UserVO userVO) {
        JSONObject s = service.updateUser(userVO);
        return CommonResponse.success("查询详情数据成功！",s);
    }
    /**
     * @Description 删除人员
     * @param
     */
    @RequestMapping(value = "/deleteUser", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> deleteUser(Integer userId) {
        JSONObject s = service.deleteUser(userId);
        return CommonResponse.success("查询详情数据成功！",s);
    }
    /**
     * @Description 查询企业所有角色
     * @param
     */
    @RequestMapping(value = "/getRoleList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RoleVO>> getRoleList() {
        List<RoleVO> roleList = service.getRoleList();
        return CommonResponse.success("查询详情数据成功！",roleList);
    }

    /**
     * @Description 查询当前企业下所有人员
     * @param
     */
    @RequestMapping(value = "/getAllUser", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<UserVO>> getAllUser() {
        List<UserVO> allUser = service.getAllUser();
        return CommonResponse.success("查询详情数据成功！",allUser);
    }
    /**
     * @Description 根据部门id查询部门下的人员
     * @param
     */
    @RequestMapping(value = "/getUsersUnderDepartment", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse< List<UserVO>> getUsersUnderDepartment(@RequestParam(required = true) Integer departmentId) {
        List<UserVO> usersUnderDepartment = service.getUsersUnderDepartment(departmentId);
        return CommonResponse.success("查询详情数据成功！",usersUnderDepartment);
    }
    /**
     * @Description 添加人员
     * @param
     */
    @RequestMapping(value = "/addUser", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> addUser(@RequestBody UserVO userVO) {
        JSONObject userVO1 = service.addUser(userVO);
        return CommonResponse.success("查询详情数据成功！",userVO1);
    }


    /**
     * @Description performHandover交接工作
     * @param
     */
    @RequestMapping(value = "/performHandover", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> performHandover(Integer targetUserId, Integer userId) {
        String s = service.performHandover(targetUserId, userId);
        return CommonResponse.success("查询详情数据成功！",s);
    }
    /**
     * @Description 转移部门
     * @param
     */
    @RequestMapping(value = "/transfer", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> transfer(Integer departmentId,Integer departmentIdOld, Integer userId) {
        JSONObject s = service.transfer(departmentId, departmentIdOld,userId);
        return CommonResponse.success("查询详情数据成功！",s);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refZzyzData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UserVO>> refZzyzData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                     String condition,
                                                     String searchObject,
                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);


        Integer departmentId = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
             departmentId = con.getInteger("departmentId");
        }

        //自定义查询，拼接查询语句
        Page<UserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());


        //自定义查询，写xml
        List<UserVO> list = service.queryUserData(page, departmentId);
        IPage<UserVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);


        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description  人员同步接口首次
     * @param
     * @Return
     */
    @RequestMapping(value = "/userInfoSyncFirst", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> userInfoSyncFirst(Integer page) {
        String s = service.userInfoSyncFirst(page);
        return CommonResponse.success("执行成功！");
    }

    /**
     * @Description  人员同步接口
     * @param
     * @Return
     */
    @RequestMapping(value = "/userInfoSync", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> userInfoSync(HttpServletRequest request) {
        String s = service.userInfoSync();
        return CommonResponse.success("执行成功！");
    }

    /**
     * @Description  人员删除
     * @param
     * @Return
     */
    @RequestMapping(value = "/userListDelete", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> userListDelete() {
        List<Integer> integers = Arrays.asList(14501, 16451, 16452, 16453, 17582, 17583, 17584, 17585, 17586, 17588, 17590, 17591, 17593, 17595, 17606, 17607, 17608, 17609, 17610, 17614, 17615, 17616, 17617, 17623, 17625, 17626, 17627, 17628, 17629, 17630, 17632, 17634, 17678, 17680, 17681, 17682, 18097, 18098, 18099, 18100, 18101, 18102, 18103, 18104, 18105, 18107, 18109, 18110, 18111, 18112, 18113, 18114, 18115, 18116, 18122, 18123, 18124, 18125, 18126, 18127, 18128, 18129, 18130, 18131, 18133, 18134, 18135, 18136, 18138, 18139, 18140, 18142, 18143, 18144, 18145, 18146, 18147, 18150, 18151, 18152, 18153, 18154, 18155, 18156, 18157, 18158, 18159, 18160, 18161, 18162, 18163, 18165, 18167, 18168, 18169, 18170, 18171, 18172, 18173, 18174, 18176, 18177, 18178, 18179, 18180, 18181, 18183, 18184, 18185, 18186, 18187, 18188, 18189, 18190, 18191, 18346, 18347, 18348, 18349, 18350, 18351, 18352, 18354, 18355, 18356, 18357, 18358, 18359, 18360, 18362, 18367, 18369, 18371, 18372, 18374, 18375, 18376, 18377, 18378, 18379, 18380, 18382, 18383, 18384, 18385, 18386, 18388, 18461, 19340, 19343, 19345, 19367, 21397, 21401, 21403, 21405, 21408, 21410, 30441, 30442, 30443, 30444, 30445, 30446, 30447, 30448, 30449, 30450, 30451, 30452, 30453, 30454, 30455, 30456, 30457, 30458, 30459, 30460, 30461, 30462, 30463, 30464, 30465, 30466, 30467, 30468, 30469, 30470, 30471, 30472, 30473, 30474, 30475, 30476, 30477, 30478, 30479, 30480, 30481, 30482, 30483, 30484, 30485, 30486, 30487, 30488, 30489, 30490, 30491, 30492, 30493, 30494, 30495, 30496, 30497, 30498, 30499, 30500, 30501, 30502, 30503, 30504, 30505, 30506, 30507, 30508, 30509, 30510, 30511, 30512, 30513, 30514, 30515, 30516, 30517, 30518, 30519, 30520, 30521, 30522, 30523, 30524, 30525, 30526, 30527, 30528, 30529, 30530, 30531, 30532, 30533, 30534, 30535, 30536, 30537, 30538, 30539, 30540, 30541, 30542, 30543, 30544, 30545, 30546, 30547, 30548, 30549, 30550, 30551, 30552, 30553, 30554, 30555, 30556, 30557, 30558, 30559, 30560, 30561, 30562, 30563, 30564, 30565, 30566, 30567, 30568, 30569, 30570, 30571, 30572, 30573, 30574, 30575, 30576, 30577, 30578, 30579, 30580, 30581, 30582, 30583, 30584, 30585, 30586, 30587, 30588, 30589, 30590, 30591, 30592, 30593, 30594, 30595, 30596, 30597, 30598, 30599, 30600, 30601, 30602, 30603, 30604, 30605, 30606, 30607, 30608, 30609, 30610, 30611, 30612, 30613, 30614, 30615, 30616, 30617, 30618, 30619, 30620, 30621, 30622, 30623, 30624, 30625, 30626, 30627, 30628, 30629, 30630, 30631, 30632, 30633, 30634, 30635, 30636, 30637, 30638, 30639, 30640, 30641, 30642, 30643, 30644, 30645, 30646, 30647, 30648, 30649, 30650, 30651, 30652, 30653, 30654, 30655, 30656, 30657, 30658, 30659, 30660, 30661, 30662, 30663, 30664, 30665, 30666, 30667, 30668, 30669, 30670, 30671, 30672, 30673, 30674, 30675, 30676, 30677, 30678, 30679, 30680, 30681, 30682, 30683, 30684, 30685, 30686, 30687, 30688, 30689, 30690, 30691, 30692, 30693, 30694, 30695, 30696, 30697, 30698, 30699, 30700, 30701, 30702, 30703, 30704, 30705, 30706, 30707, 30708, 30709, 30710, 30711, 30712, 30713, 30714, 30715, 30716, 30717, 30718, 30719, 30720, 30721, 30722, 30723, 30724, 30725, 30726, 30727, 30728, 30729, 30730, 30731, 30732, 30733, 30734, 30735, 30736, 30737, 30738, 30739, 30740, 30741, 30742, 30743, 30744, 30745, 30746, 30747, 30748, 30749, 30750, 30751, 30752, 30753, 30754, 30755, 30756, 30757, 30758, 30759, 30760, 30761, 30762, 30763, 30764, 30765, 30766, 30767, 30768, 30769, 30770, 30771, 30772, 30773, 30774, 30775, 30776, 30777, 30778, 30779, 30780, 30781);

        for (Integer integer : integers) {
            JSONObject jsonObject = service.deleteUser(integer);
            logger.info(jsonObject.getString("message"));
        }

        return CommonResponse.success("执行成功！");
    }

}
