package com.ejianc.foundation.mdm.service.impl;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.mdm.bean.DataModelCategoryEntity;
import com.ejianc.foundation.mdm.mapper.DataModelCategoryMapper;
import com.ejianc.foundation.mdm.service.IDataModelCategoryService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class DataModelCategoryServiceImpl extends BaseServiceImpl<DataModelCategoryMapper, DataModelCategoryEntity> implements IDataModelCategoryService {

	@Override
	public List<DataModelCategoryEntity> queryDataModelCategoryList(String categoryName) {
		QueryWrapper<DataModelCategoryEntity> queryWrapper = new QueryWrapper<>();
		if(StringUtils.isNotBlank(categoryName)) {
			queryWrapper.like("category_name", categoryName);
		}
		queryWrapper.orderByAsc("sequence");
		List<DataModelCategoryEntity> resultList = super.list(queryWrapper);
		return resultList;
	}

}
