package com.ejianc.foundation.bulidMaterialMdm.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.bulidMaterialMdm.bean.*;
import com.ejianc.foundation.bulidMaterialMdm.mapper.OrgMapper;
import com.ejianc.foundation.bulidMaterialMdm.mapper.UserMapper;
import com.ejianc.foundation.bulidMaterialMdm.service.ISystemRequestService;
import com.ejianc.foundation.bulidMaterialMdm.service.IUserService;
import com.ejianc.foundation.bulidMaterialMdm.vo.RoleVO;
import com.ejianc.foundation.bulidMaterialMdm.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.List;

/**
 * 组织部门信息
 *
 * @author generator
 *
 */
@Service("userService")
public class UserService implements IUserService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISystemRequestService requestService;
    @Autowired
    private UserMapper mapper;
    @Autowired
    private OrgMapper orgMapper;
    @Override
    public String performHandover(Integer targetUserId, Integer userId) {
        if (targetUserId == null || userId == null ){
            throw new BusinessException("承接工作的人员id、用户ID不允许为空！" );
        }
        JSONObject param = new JSONObject();
        param.put("targetUserId",targetUserId);
        param.put("userId",userId);


        String responseBody = requestService.sendPostRequest("user/performHandover", param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
        Integer code = jsonObject.getInteger("code");
        if (code == 0){
            message = jsonObject.getString("message");
        }else {
            message = jsonObject.getString("message");
            throw new BusinessException("工作交接失败！"+message );
        }
        return message;
    }

    @Override
    public JSONObject updateUser(UserVO userVO) {
        if (userVO.getUserId() == null ){
            throw new BusinessException("用户ID不允许为空！" );
        }
        //JSONObject param = JSONObject.parseObject(JSONObject.toJSONString(userVO));

        JSONObject param = new JSONObject();
        if(userVO.getDuty() != null){
            param.put("duty",userVO.getDuty());
        }
        if(userVO.getPassword() != null){
            param.put("password",userVO.getPassword());
        }
        if(userVO.getPhone() != null){
            param.put("phone",userVO.getPhone());
        }
        if(userVO.getRealName() != null){
            param.put("realName",userVO.getRealName());
        }
        if(userVO.getRoleId() != null){
            param.put("roleId",userVO.getRoleId());
        }
        if(userVO.getUserId() != null){
            param.put("userId",userVO.getUserId());
        }

        String responseBody = requestService.sendPostRequest("user/update", param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
//        Integer code = jsonObject.getInteger("code");
//        if (code == 0){
//            message = jsonObject.getString("object")+"";
//        }else {
//            message = jsonObject.getString("message");
//        }
        return jsonObject;
    }

    @Override
    public JSONObject deleteUser(Integer userId) {
        if (userId == null){
            throw new BusinessException("用户id不允许为空！" );
        }
        JSONObject param = new JSONObject();
        param.put("userId",userId);

        String responseBody = requestService.sendPostRequest("user/delete/",param);

        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
//        Integer code = jsonObject.getInteger("code");
//        if (code == 0){
//            message = jsonObject.getString("object")+"";
//        }else {
//            message = jsonObject.getString("message");
//        }
        return jsonObject;
    }

    @Override
    public List<RoleVO> getRoleList() {
        String url = "user/getRoleList";
        JSONObject param = new JSONObject();

        String responseBody = requestService.sendPostRequest(url,param);

        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
        Integer code = jsonObject.getInteger("code");
        List<RoleVO> roleVO = null;
        if (code == 0){
            roleVO = JSONObject.parseArray(jsonObject.getString("object"), RoleVO.class);
        }else {
            message = jsonObject.getString("message");
            throw new BusinessException("返回数据异常！"+message );
        }
        return roleVO;
    }

    @Override
    public List<UserVO> getAllUser() {
        String url = "user/getAllUser";

        JSONObject param = new JSONObject();
        String responseBody = requestService.sendPostRequest(url,param);

        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
        Integer code = jsonObject.getInteger("code");
        List<UserVO> userVOS = null;
        if (code == 0){
            userVOS = JSONObject.parseArray(jsonObject.getJSONObject("object").getString("users"), UserVO.class);
        }else {
            message = jsonObject.getString("message");
            throw new BusinessException("返回数据异常！"+message );
        }
        return userVOS;
    }

    @Override
    public List<UserVO> getUsersUnderDepartment(Integer departmentId) {
        if (departmentId == null){
            throw new BusinessException("部门ID不允许为空！" );
        }
        String url = "user/getUsersUnderDepartment";

        JSONObject param = new JSONObject();
        param.put("departmentId",departmentId);

        String responseBody = requestService.sendPostRequest(url,param);

        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
        Integer code = jsonObject.getInteger("code");
        List<UserVO> userVOS = null;
        if (code == 0){
            userVOS = JSONObject.parseArray(jsonObject.getString("object"), UserVO.class);
        }else {
            message = jsonObject.getString("message");
            throw new BusinessException("返回数据异常！"+message );
        }
        return userVOS;
    }

    @Override
    public JSONObject addUser(UserVO userVO) {
        if (userVO.getDepartmentId() == null ||
                userVO.getDuty() == null ||
                userVO.getPassword() == null ||
                userVO.getPhone() == null ||
                userVO.getRealName() == null ||
                userVO.getRoleId() == null ||
                userVO.getUsername() == null ){
            throw new BusinessException("职位、密码、电话、姓名、角色Id，用户名不允许为空！" );
        }
        try {
            byte[] encrypted = encrypt(userVO.getPassword(), "227d756c4eb9dc9071e423021c72b75f");
            String encryptedBase64 = Base64.getEncoder().encodeToString(encrypted);
            logger.info("加密过后的密码：{}",encryptedBase64);
            userVO.setPassword(encryptedBase64);
        } catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject param = JSONObject.parseObject(JSONObject.toJSONString(userVO));

        String responseBody = requestService.sendPostRequest("user/add", param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
//        Integer code = jsonObject.getInteger("code");
//        UserVO userVO1 = null;
//        if (code == 0){
//            userVO1 = JSONObject.parseObject(jsonObject.getString("object"), UserVO.class);
//        }else {
//            message = jsonObject.getString("message");
//            throw new BusinessException("返回数据异常！"+message );
//        }
        return jsonObject;
    }

    @Override
    public JSONObject transfer(Integer departmentId,Integer departmentIdOld, Integer userId) {
        if (departmentId == null || userId == null ){
            throw new BusinessException("部门Id、用户ID不允许为空！" );
        }
        JSONObject param = new JSONObject();
        param.put("departmentId",departmentId);
        param.put("userId",userId);


        String responseBody = requestService.sendPostRequest("user/transfer", param);
        String message ="";
        JSONObject jsonObject = JSONObject.parseObject(responseBody);
//        Integer code = jsonObject.getInteger("code");
//        if (code == 0){
//            message = jsonObject.getString("object")+"";
//        }else {
//            message = jsonObject.getString("message");
//            //转换失败，进入手动处理库
//
//        }
        return jsonObject;
    }

    @Override
    public List<UserVO> queryUserData(Page<UserVO> page,Integer departmentId) {
        return mapper.queryUserData(page, departmentId);
    }

    private static final String AES_ALGORITHM = "AES";

    public  byte[] encrypt(String plaintext, String key) throws Exception {
        SecretKeySpec secretKeySpec = new
                SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), AES_ALGORITHM);
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        removeJceLimit();
         cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec);
         return cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
         }
    public  byte[] decrypt(byte[] ciphertext, String key) throws Exception {
         SecretKeySpec secretKeySpec = new
                SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), AES_ALGORITHM);
         Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        removeJceLimit();
        cipher.init(Cipher.DECRYPT_MODE, secretKeySpec);
        return cipher.doFinal(ciphertext);
        }

    /**
     * 组织同步接口 (首次同步)
     * @return
     */
    @Override
    public String userInfoSyncFirst(Integer page) {
        logger.info("筑材网同步用户信息开始---------------->");
        /**
         * 1. 获取今天修改的用户信息
         * 2. 判断是新增还是删除还是修改
         * 3.   分别执行对应操作，插入执行记录
         *      新增：
         *      删除：
         *      修改：
         * 4.
         * 5.
         */
        //1
//        int page = 0;
//        boolean flag =true;
//        while (flag) {
            List<MadUserEntity> todayUpdateData = mapper.selectWithPage(page*50);

            if (todayUpdateData != null && todayUpdateData.size() > 0) {
                for (MadUserEntity todayUpdateDatum : todayUpdateData) {
                    //新增
                    //从记录表中获取筑材网对应父id
                    Integer materialIdByMdmId = orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                    /**
                     * 同步组织时，虚拟组织不需要，其他项目部层级不需要
                     */
                    if (todayUpdateDatum.getOrgid().equals(1502571152642412546L) ||//集团公司机关
                            todayUpdateDatum.getOrgid().equals(1502571152701132801L) ||//集团子公司
                            todayUpdateDatum.getOrgid().equals(1502571152793407490L) ||//集团分公司
                            todayUpdateDatum.getOrgid().equals(1502571152847933442L) ||//项目经理部
                            todayUpdateDatum.getOrgid().equals(1502571155922358273L) ||//其它施工项目部
                            todayUpdateDatum.getOrgid().equals(1502571152583692289L)//郑州一建集团
                    ) {//上级组织是虚拟层级则所属组织id设置为郑州一建
                        materialIdByMdmId = 76236;
                    } else {
                        if (materialIdByMdmId == null) {//非二级指标不允许为空，为空则跳出循环
                            logger.info("组织:{} 的上级组织未同步！", todayUpdateDatum.getOrgid());
                            continue;
                        }
                    }
                    //进行插入操作
                   logger.info("筑材网用户信息新增，id：{}", todayUpdateDatum.getMasterDataId());
                    UserVO userVO = new UserVO();
                    userVO.setDepartmentId(materialIdByMdmId);
                    userVO.setDuty("无");
                    userVO.setPassword("1234qwer");
                    userVO.setPhone(todayUpdateDatum.getMobilephone());
                    userVO.setRealName(todayUpdateDatum.getEmployeename());
                    userVO.setRoleId("396872");
                    //userVO.setUsername("zzyj"+todayUpdateDatum.getMobilephone().substring(todayUpdateDatum.getMobilephone().length()-6));
                    userVO.setUsername(todayUpdateDatum.getMobilephone());

                    JSONObject jsonObject = addUser(userVO);
                    //判断操作结果
                    Integer code = jsonObject.getInteger("code");
                    if (code == 0) {//筑材网新增成功
                        logger.info("筑材网新增成功，id：{}", todayUpdateDatum.getMasterDataId());
                        UserVO userVO1 = JSONObject.parseObject(jsonObject.getString("object"), UserVO.class);

                        //记录表新增
                        MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增用户", 1, "");
                        mapper.insertSendRecord(entity);
                        //组织中间表新增
                        MaterialUserEntity materialUserEntity =
                                new MaterialUserEntity(todayUpdateDatum.getMasterDataId(), new Date(), 1, materialIdByMdmId, userVO.getDuty(), userVO.getPassword(),
                                        userVO.getPhone(), userVO.getRealName(), userVO.getRoleId(), userVO.getUsername(), userVO1.getUserId());
                        mapper.insertUserInfo(materialUserEntity);
                    } else {
                        String message = jsonObject.getString("message");
                        logger.info("筑材网新增失败，message：{}", message);
                        //记录表新增
                        MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增用户", 2, message);
                        mapper.insertSendRecord(entity);
                    }


                    try {
                        Thread.sleep(250); // 暂停0.5秒
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else {
//                flag = false;
                logger.info("页面信息不存在！");
            }
//            page++;
//        }
        return "同步成功！";
    }


    /**
     * 组织同步接口
     * @return
     */
    @Override
    public String userInfoSync() {
        logger.info("筑材网同步用户信息开始---------------->");
        /**
         * 1. 获取今天修改的用户信息
         * 2. 判断是新增还是删除还是修改
         * 3.   分别执行对应操作，插入执行记录
         *      新增：
         *      删除：
         *      修改：
         * 4.
         * 5.
         */
        //1
        List<MadUserEntity> todayUpdateData = mapper.getTodayUpdateData();

        if (todayUpdateData != null){
            for (MadUserEntity todayUpdateDatum : todayUpdateData) {
                    //2
                    if (todayUpdateDatum.getDataType() == 1) {
                        //新增
                        //从记录表中获取筑材网对应父id
                        Integer materialIdByMdmId = orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                        /**
                         * 同步组织时，虚拟组织不需要，其他项目部层级不需要
                         */
                        if (todayUpdateDatum.getOrgid().equals(1502571152642412546L)||//集团公司机关
                                todayUpdateDatum.getOrgid().equals(1502571152701132801L)||//集团子公司
                                todayUpdateDatum.getOrgid().equals(1502571152793407490L)||//集团分公司
                                todayUpdateDatum.getOrgid().equals(1502571152847933442L)||//项目经理部
                                todayUpdateDatum.getOrgid().equals(1502571155922358273L)||//其它施工项目部
                                todayUpdateDatum.getOrgid().equals(1502571152583692289L)//郑州一建集团

                        ) {//上级组织是虚拟层级则所属组织id设置为郑州一建
                            materialIdByMdmId = 396872;
                        } else {
                            if (materialIdByMdmId == null) {//非二级指标不允许为空，为空则跳出循环
                                logger.info("组织:{} 的上级组织未同步！", todayUpdateDatum.getOrgid());
                                continue;
                            }
                        }
                        //进行插入操作
                        logger.info("筑材网用户信息新增，id：{}", todayUpdateDatum.getMasterDataId());
                        UserVO userVO = new UserVO();
                        userVO.setDepartmentId(materialIdByMdmId);
                        userVO.setDuty("无");
                        userVO.setPassword("1234qwer");
                        userVO.setPhone(todayUpdateDatum.getMobilephone());
                        userVO.setRealName(todayUpdateDatum.getEmployeename());
                        userVO.setRoleId("396872");
                        //userVO.setUsername("zzyj"+todayUpdateDatum.getMobilephone().substring(todayUpdateDatum.getMobilephone().length()-6));
                        userVO.setUsername(todayUpdateDatum.getMobilephone());
                        JSONObject jsonObject = addUser(userVO);
                        //判断操作结果
                        Integer code = jsonObject.getInteger("code");
                        if (code == 0) {//筑材网新增成功
                            UserVO userVO1 = JSONObject.parseObject(jsonObject.getString("object"), UserVO.class);

                            //记录表新增
                            MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增用户", 1, "");
                            mapper.insertSendRecord(entity);
                            //组织中间表新增
                            MaterialUserEntity materialUserEntity =
                                    new MaterialUserEntity(todayUpdateDatum.getMasterDataId(), new Date(), 1,materialIdByMdmId, userVO.getDuty(),userVO.getPassword(),
                                            userVO.getPhone(),userVO.getRealName(), userVO.getRoleId(),userVO.getUsername(), userVO1.getUserId());
                            mapper.insertUserInfo(materialUserEntity);
                        } else {
                            String message = jsonObject.getString("message");
                            //记录表新增
                            MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "新增用户", 2, message);
                            mapper.insertSendRecord(entity);
                        }

                    } else if (todayUpdateDatum.getDataType() == 2) {
                        //修改
                        //从用户记录表中获取筑材网对应用户id
                        MaterialUserEntity materialUser = mapper.getUserInfoByMdmId(todayUpdateDatum.getMasterDataId());
                        Integer materialId = materialUser != null ?materialUser.getUserId():null;

                        if (materialId != null) {
                            //从组织记录表中获取筑材网对应组织id
                            Integer materialparentId = 396872;
                            if (todayUpdateDatum.getOrgid() != null && !(todayUpdateDatum.getOrgid().equals(1502571152642412546L)||//集团公司机关
                                    todayUpdateDatum.getOrgid().equals(1502571152701132801L)||//集团子公司
                                    todayUpdateDatum.getOrgid().equals(1502571152793407490L)||//集团分公司
                                    todayUpdateDatum.getOrgid().equals(1502571152847933442L)||//项目经理部
                                    todayUpdateDatum.getOrgid().equals(1502571155922358273L)||//其它施工项目部
                                    todayUpdateDatum.getOrgid().equals(1502571152583692289L)//郑州一建集团
                            )) {
                                materialparentId = orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                            }
                            if (materialUser.getDepartmentId().equals(materialparentId)) {//部门不变
                                logger.info("筑材网用户信息更新，id：{}", todayUpdateDatum.getMasterDataId());
                                //执行更新操作
                                UserVO userVO = new UserVO();
                                //userVO.setDepartmentId(materialparentId);//筑材网不允许修改
                                //userVO.setDuty("无");
                                //userVO.setPassword("1234qwer");
                                if (!materialUser.getPhone().equals(todayUpdateDatum.getMobilephone())) {
                                    userVO.setPhone(todayUpdateDatum.getMobilephone());
                                }
                                if (!materialUser.getRealName().equals(todayUpdateDatum.getEmployeename())) {
                                    userVO.setRealName(todayUpdateDatum.getEmployeename());
                                }
                                //userVO.setRoleId("396872");
                                // userVO.setUsername(todayUpdateDatum.getMobilephone());//筑材网不允许修改
                                userVO.setUserId(materialId);

                                JSONObject jsonObject = updateUser(userVO);
                                //判断操作结果
                                Integer code = jsonObject.getInteger("code");
                                if (code == 0) {//筑材网修改成功
                                    String message = jsonObject.getString("object") + "";

                                    //记录表新增
                                    MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改用户", 1, message);
                                    mapper.insertSendRecord(entity);

                                    //组织中间表修改
                                    MaterialUserEntity materialUserEntity = new MaterialUserEntity(todayUpdateDatum.getMasterDataId(), new Date(), 2, materialparentId, userVO.getDuty(), userVO.getPassword(),
                                            todayUpdateDatum.getMobilephone(),todayUpdateDatum.getEmployeename(), userVO.getRoleId(), userVO.getUsername(), materialId);

                                    mapper.updateUserInfo(materialUserEntity);

                                } else {
                                    String message = jsonObject.getString("message");
                                    //记录表新增
                                    MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改用户", 2, message);
                                    mapper.insertSendRecord(entity);
                                }
                            }else {//部门改变，走转移部门接口
                                JSONObject transfer = transfer(materialparentId, materialUser.getDepartmentId(), materialId);
                                        Integer code = transfer.getInteger("code");
                                        if (code == 0){
                                            String message = transfer.getString("message");
                                            //记录表新增
                                            MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "用户转换部门", 1, message);
                                            mapper.insertSendRecord(entity);

                                            //修改用户中间表的部门id
                                            MaterialUserEntity materialUserEntity = new MaterialUserEntity();
                                            materialUserEntity.setUserId(materialId);
                                            materialUserEntity.setLastUpdateTime(new Date());
                                            materialUserEntity.setDepartmentId(materialparentId);
                                            mapper.updateUserDeptId(materialUserEntity);
                                        }else {
                                            String message = transfer.getString("message");
                                            //记录表新增
                                            MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "用户转换部门", 2, message);
                                            mapper.insertSendRecord(entity);
                                            //转换失败，进入手动处理库
                                            MaterialUserTransferEntity map = BeanMapper.map(materialUser, MaterialUserTransferEntity.class);
                                            map.setDepartmentIdNew(materialparentId);
                                            map.setTransferState(2);//转换状态（1：成功，2：失败）
                                            map.setErrorMessage(message);
                                            mapper.insertTransferRecord(map);
                                        }

                            }
                        }else {
                            //修改新增
                            //从记录表中获取筑材网对应父id
                            Integer materialIdByMdmId = orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                            /**
                             * 同步组织时，虚拟组织不需要，其他项目部层级不需要
                             */
                            if (todayUpdateDatum.getOrgid().equals(1502571152642412546L)||//集团公司机关
                                    todayUpdateDatum.getOrgid().equals(1502571152701132801L)||//集团子公司
                                    todayUpdateDatum.getOrgid().equals(1502571152793407490L)||//集团分公司
                                    todayUpdateDatum.getOrgid().equals(1502571152847933442L)||//项目经理部
                                    todayUpdateDatum.getOrgid().equals(1502571155922358273L)||//其它施工项目部
                                    todayUpdateDatum.getOrgid().equals(1502571152583692289L)//郑州一建集团

                            ) {//上级组织是虚拟层级则所属组织id设置为郑州一建
                                materialIdByMdmId = 396872;
                            } else {
                                if (materialIdByMdmId == null) {//非二级指标不允许为空，为空则跳出循环
                                    logger.info("组织:{} 的上级组织未同步！", todayUpdateDatum.getOrgid());
                                    continue;
                                }
                            }
                            //进行插入操作
                            logger.info("筑材网用户信息修改新增，id：{}", todayUpdateDatum.getMasterDataId());
                            UserVO userVO = new UserVO();
                            userVO.setDepartmentId(materialIdByMdmId);
                            userVO.setDuty("无");
                            userVO.setPassword("1234qwer");
                            userVO.setPhone(todayUpdateDatum.getMobilephone());
                            userVO.setRealName(todayUpdateDatum.getEmployeename());
                            userVO.setRoleId("396872");
                            //userVO.setUsername("zzyj"+todayUpdateDatum.getMobilephone().substring(todayUpdateDatum.getMobilephone().length()-6));
                            userVO.setUsername(todayUpdateDatum.getMobilephone());

                            JSONObject jsonObject = addUser(userVO);
                            //判断操作结果
                            Integer code = jsonObject.getInteger("code");
                            if (code == 0) {//筑材网新增成功
                                UserVO userVO1 = JSONObject.parseObject(jsonObject.getString("object"), UserVO.class);

                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改新增用户", 1, "");
                                mapper.insertSendRecord(entity);
                                //组织中间表新增
                                MaterialUserEntity materialUserEntity =
                                        new MaterialUserEntity(todayUpdateDatum.getMasterDataId(), new Date(), 1,materialIdByMdmId, userVO.getDuty(),userVO.getPassword(),
                                                userVO.getPhone(),userVO.getRealName(), userVO.getRoleId(),userVO.getUsername(), userVO1.getUserId());
                                mapper.insertUserInfo(materialUserEntity);
                            } else {
                                String message = jsonObject.getString("message");
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "修改新增用户", 2, message);
                                mapper.insertSendRecord(entity);
                            }
                        }
                    } else if (todayUpdateDatum.getDataType() == 3) {//删除
                        //从记录表中获取筑材网对应id
                        Integer materialId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getMasterDataId());

                        logger.info("筑材网组织信息删除，id：{}", todayUpdateDatum.getMasterDataId());
                        if(materialId != null) {
                            //执行删除操作
                            JSONObject jsonObject = deleteUser(materialId);
                            //判断操作结果
                            Integer code = jsonObject.getInteger("code");
                            if (code == 0) {//筑材网删除成功
                                String message = jsonObject.getString("object") + "";//筑材网返回信息
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "删除用户", 1, message);
                                mapper.insertSendRecord(entity);

                                //从记录表中获取筑材网对应父id
                                Integer materialparentId = null;
                                if (todayUpdateDatum.getOrgid() != null) {
                                    materialparentId = mapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                                }
                                //用户中间表修改
                                MaterialUserEntity materialUserEntity = new MaterialUserEntity(todayUpdateDatum.getMasterDataId(), new Date(),
                                        3, materialId);
                                mapper.deleteUserInfo(materialUserEntity);

                            } else {
                                String message = jsonObject.getString("message");
                                //记录表新增
                                MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "删除用户", 2, message);
                                mapper.insertSendRecord(entity);
                            }
                        }else {
                            //记录表新增
                            MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "删除用户", 2, "中间表查询数据失败！");
                            mapper.insertSendRecord(entity);
                        }
                    }

                try {
                    Thread.sleep(500); // 暂停0.5秒
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        return  "同步成功！";
    }

    /**
     * 1、通过反射去除JCE加密限制，此方法只限于Java1.8，直接复制（可能报错，引用java.lang.reflect下的包即可）
     * 2、在main方法中加密操作之前调用一下这个方法就OK了
     */
    private static void removeJceLimit() {

        try {

            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            field.setAccessible(true);

            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & ~Modifier.FINAL);

            field.set(null, false);

        } catch (ClassNotFoundException | NoSuchFieldException | SecurityException | IllegalArgumentException | IllegalAccessException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public UserVO getUserInfoByMdmId(Long mdmId){
        MaterialUserEntity materialUser = mapper.getUserInfoByMdmId(mdmId);
        return BeanMapper.map(materialUser,UserVO.class);
    }

}
