package com.ejianc.foundation.bulidMaterialMdm.controller;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bulidMaterialMdm.mapper.ProjectMapper;
import com.ejianc.foundation.bulidMaterialMdm.service.IProjectService;
import com.ejianc.foundation.bulidMaterialMdm.vo.ProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;

/**
 * 筑材信息
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectInfo")
public class ProjectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IProjectService service;

    @Autowired
    private ProjectMapper projectMapper;


    /**
     * @Description insertProjectInfo
     * @param
     */
    @RequestMapping(value = "/insertProjectInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> insertProjectInfo(@RequestBody ProjectVO projectVO) {
        JSONObject s = service.insertProjectInfo(projectVO);
        return CommonResponse.success("查询详情数据成功！",s);
    }
    /**
     * @Description selectProjectInfo
     * @param
     */
    @RequestMapping(value = "/selectProjectInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProjectVO>> selectProjectInfo() {
        List<ProjectVO> projectVO = service.selectProjectInfo();
        return CommonResponse.success("查询详情数据成功！",projectVO);
    }
    /**
     * @Description selectProjectInfo
     * @param
     */
    @RequestMapping(value = "/selectProjectInfoById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectVO> selectProjectInfoById(@RequestParam(required = false) Integer projectId) {
        ProjectVO projectVO = service.selectProjectInfoById(projectId);
        return CommonResponse.success("查询详情数据成功！",projectVO);
    }
    /**
     * @Description updateProjectInfo
     * @param
     */
    @RequestMapping(value = "/updateProjectInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> updateProjectInfo(@RequestBody ProjectVO projectVO) {
        JSONObject s = service.updateProjectInfo(projectVO);
        return CommonResponse.success("查询详情数据成功！",s);
    }
    /**
     * @Description deleteProjectInfo
     * @param
     */
    @RequestMapping(value = "/deleteProjectInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> deleteProjectInfo(@RequestParam(required = true) Integer departmentId) {
        JSONObject s = service.deleteProjectInfo(departmentId);
        return CommonResponse.success("查询详情数据成功！",s);
    }



    /**
     * @Description  组织同步接口
     * @param
     * @Return
     */
    @RequestMapping(value = "/projectInfoSync", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> projectInfoSync(HttpServletRequest request) {
        String s = service.projectInfoSync();
        return CommonResponse.success("执行成功！");
    }

    /**
     * @Description  组织同步接口首次
     * @param
     * @Return
     */
    @RequestMapping(value = "/projectInfoSyncFirst", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> projectInfoSyncFirst(HttpServletRequest request) {
        String s = service.projectInfoSyncFirst();
        return CommonResponse.success("执行成功！");
    }

}
