/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.bean.MessageEntity;
import com.ejianc.foundation.message.bean.MsgTypeEntity;
import com.ejianc.foundation.message.service.IMessageService;
import com.ejianc.foundation.message.service.IMsgTypeService;
import com.ejianc.foundation.message.vo.MessageVO;
import com.ejianc.foundation.message.vo.PageParam;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/message/"})
public class MessageController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMessageService messageService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IMsgTypeService msgTypeService;

    @PostMapping(value={"page"})
    public CommonResponse<JSONObject> pageList(@RequestBody PageParam pageParam) {
        JSONObject resp = new JSONObject();
        JSONObject data = new JSONObject();
        List<Object> voList = null;
        pageParam.setTenantId(InvocationInfoProxy.getTenantid());
        long count = this.messageService.queryCount(pageParam);
        voList = count > 0L ? this.messageService.queryList(pageParam) : new ArrayList();
        data.put("total", (Object)count);
        data.put("pageSize", (Object)pageParam.getPageSize());
        data.put("pageNum", (Object)pageParam.getPageNum());
        data.put("records", voList);
        resp.put("data", (Object)data);
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"delMessages"})
    public CommonResponse<String> delMessages(@RequestBody List<MessageVO> messageList) {
        this.messageService.delMessage(messageList);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"updateMessagesStatus"})
    public CommonResponse<String> setMsgReadedStatus(@RequestBody List<Long> messageIds) {
        this.messageService.updateMessageStatus(messageIds);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @GetMapping(value={"getUserMsg"})
    public CommonResponse<JSONObject> getUserMsg(@RequestParam(value="msgId") Long msgId) {
        JSONObject resp = null;
        MessageEntity messageEntity = (MessageEntity)((Object)this.messageService.selectById(msgId));
        resp = (JSONObject)BeanMapper.map((Object)((Object)messageEntity), JSONObject.class);
        CommonResponse attachResp = this.attachmentApi.queryListBySourceId(msgId, null, null, null);
        if (attachResp.isSuccess()) {
            resp.put("attachmentList", attachResp.getData());
        } else {
            this.logger.error("\u67e5\u8be2\u6d88\u606f\u3010id-{}\u3011\u5bf9\u5e94\u9644\u4ef6\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff01", (Object)msgId, (Object)attachResp.getMsg());
        }
        CommonResponse uservoResp = this.userApi.queryUserByUserCode(messageEntity.getCreateUserCode());
        if (!uservoResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u6d88\u606f\u3010id-{}\uff0cuserCode-{}\u3011\u521b\u5efa\u4eba\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff01", new Object[]{msgId, messageEntity.getCreateUserCode(), attachResp.getMsg()});
        } else {
            UserVO user = (UserVO)uservoResp.getData();
            if (null != user) {
                resp.put("sendUserName", (Object)user.getUserName());
                resp.put("sendUserMobile", (Object)user.getUserMobile());
                resp.put("sendUserEmail", (Object)user.getUserEmail());
                resp.put("sendUserAvator", (Object)user.getAvator());
            }
        }
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"updateAllStatus"})
    public CommonResponse<String> updateAllStatus() {
        this.messageService.updateAllMessageStatus();
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @GetMapping(value={"unread/count"})
    public CommonResponse<Long> queryMyUnreadCount() {
        Long userId = InvocationInfoProxy.getUserid();
        PageParam pageParam = new PageParam();
        pageParam.setStatus(Integer.valueOf(0));
        pageParam.setReceiver(userId);
        pageParam.setTenantId(InvocationInfoProxy.getTenantid());
        long count = this.messageService.queryCount(pageParam);
        return CommonResponse.success((Object)count);
    }

    @GetMapping(value={"sendMessage"})
    public CommonResponse<String> sendMessage(@RequestParam String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return CommonResponse.error((String)"\u53c2\u6570\u9519\u8bef\uff0c\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01");
        }
        this.logger.info("\u6536\u5230\u6d88\u606f-\u3010{}\u3011, \u5f85\u521d\u6b65\u9a8c\u8bc1\u53c2\u6570\u53d1\u9001\u6d88\u606f\u961f\u5217\uff01", (Object)message);
        try {
            PushMsgParameter pushMsgParameter = (PushMsgParameter)JSONObject.parseObject((String)message, PushMsgParameter.class);
            if (StringUtils.isBlank((CharSequence)pushMsgParameter.getMsgType())) {
                return CommonResponse.error((String)"\u6d88\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)pushMsgParameter.getSubject()) && StringUtils.isBlank((CharSequence)pushMsgParameter.getContent())) {
                return CommonResponse.error((String)"\u6d88\u606f\u6807\u9898\u548c\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)pushMsgParameter.getTenantId())) {
                return CommonResponse.error((String)"\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.messageService.sendMessage(pushMsgParameter);
        }
        catch (Exception e) {
            this.logger.info("\u6d88\u606f-\u3010{}\u3011\u53d1\u9001\u6d88\u606f\u961f\u5217\u5f02\u5e38", (Throwable)e);
            e.printStackTrace();
            return CommonResponse.success((String)"\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
        }
        return CommonResponse.success((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\uff01");
    }

    @GetMapping(value={"queryMsgType"})
    public CommonResponse<List<MsgTypeEntity>> queryMsgType() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.msgTypeService.list((Wrapper)queryWrapper);
        return CommonResponse.success((Object)list);
    }
}

