/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="ddOpenApp")
public class DdOpenAppServiceImpl
implements IMsgSendChannelProcessor {
    private static Logger logger = LoggerFactory.getLogger(DdOpenAppServiceImpl.class);
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IThirdSystemApi thirdSystemApi;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${ejc.dingding.appSecret:https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2}")
    private String sendDdUrl;

    @Override
    public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
        JSONObject configJson = null;
        if (StringUtils.isNotBlank((CharSequence)configInfo)) {
            configJson = JSON.parseObject((String)configInfo);
        }
        String customKey = configJson.getString("customKey");
        String customSecret = configJson.getString("customSecret");
        String corpId = configJson.getString("corpId");
        Long ddAppid = configJson.getLong("appid");
        JSONObject dingdingParams = pushMsgParameter.getDingdingParams();
        CommonResponse ddAccessTokenResult = this.thirdSystemApi.getDdOpenAppAccessToken(customKey, customSecret, corpId);
        if (!ddAccessTokenResult.isSuccess()) {
            ddAccessTokenResult = this.thirdSystemApi.getDdOpenAppAccessToken(customKey, customSecret, corpId);
        }
        String ddAccessToken = (String)ddAccessTokenResult.getData();
        logger.info("\u83b7\u53d6\u9489\u9489access Token\u7ed3\u679c\uff1a" + ddAccessToken);
        ArrayList<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
        CommonResponse userResponse = this.userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(), Long.valueOf(Long.parseLong(pushMsgParameter.getTenantId())));
        if (userResponse.isSuccess()) {
            List userVos = (List)userResponse.getData();
            for (UserVO userVo : userVos) {
                String linkDdUrl = "dingtalk://dingtalkclient/action/openapp?corpid=?corpid=" + customKey + "&container_type=work_platform&app_id=" + ddAppid + "&redirect_type=jump&redirect_url=";
                if (StringUtils.isBlank((CharSequence)userVo.getDingdingId())) {
                    MsgSendResponse response = new MsgSendResponse("0", "\u9489\u9489\u6d88\u606f\u53d1\u9001\u5931\u8d25", userVo.getDingdingId());
                    logger.info("\u5411" + userVo.getUserName() + "\u53d1\u9001\u9489\u9489\u5931\u8d25!\u8be5\u7528\u6237\u672a\u7ed1\u5b9a\u9489\u9489\u8d26\u53f7\uff01");
                    messageResponseList.add(response);
                    continue;
                }
                try {
                    DefaultDingTalkClient client = new DefaultDingTalkClient(this.sendDdUrl);
                    OapiMessageCorpconversationAsyncsendV2Request request = new OapiMessageCorpconversationAsyncsendV2Request();
                    request.setAgentId(ddAppid);
                    request.setUseridList(userVo.getDingdingId());
                    request.setToAllUser(Boolean.valueOf(false));
                    OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
                    String maurl = null;
                    if (dingdingParams.get((Object)"maurl") != null) {
                        maurl = dingdingParams.getString("maurl");
                        maurl = maurl.contains("dingdingid") ? maurl.replaceAll("%7Bdingdingid%7D", userVo.getDingdingId()).replaceAll("%7bdingdingid%7d", userVo.getDingdingId()).replaceAll("\\{dingdingid\\}", userVo.getDingdingId()) : (maurl.contains("userid") ? maurl.replaceAll("%7Buserid%7D", userVo.getId().toString()).replaceAll("%7buserid%7d", userVo.getId().toString()).replaceAll("\\{userid\\}", userVo.getId().toString()) : (maurl.contains("?") ? maurl + "&userid=" + userVo.getId().toString() : maurl + "?userid=" + userVo.getId().toString()));
                        try {
                            maurl = URLEncoder.encode(maurl, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        linkDdUrl = linkDdUrl + maurl;
                    }
                    String linkPcDdUrl = "dingtalk://dingtalkclient/page/link?url=" + maurl + "&pc_slide=true";
                    if (dingdingParams.get((Object)"type") != null) {
                        String type = dingdingParams.getString("type");
                        if ("text".equals(type)) {
                            msg.setMsgtype("text");
                            msg.setText(new OapiMessageCorpconversationAsyncsendV2Request.Text());
                            msg.getText().setContent(dingdingParams.getString("content"));
                            request.setMsg(msg);
                        } else if ("oa".equals(type)) {
                            msg.setOa(new OapiMessageCorpconversationAsyncsendV2Request.OA());
                            msg.getOa().setHead(new OapiMessageCorpconversationAsyncsendV2Request.Head());
                            msg.getOa().getHead().setText(dingdingParams.getString("title"));
                            msg.getOa().setBody(new OapiMessageCorpconversationAsyncsendV2Request.Body());
                            msg.getOa().getBody().setTitle(dingdingParams.getString("title"));
                            if (dingdingParams.get((Object)"content") != null) {
                                msg.getOa().getBody().setContent(dingdingParams.getString("content"));
                            }
                            ArrayList<OapiMessageCorpconversationAsyncsendV2Request.Form> form = new ArrayList<OapiMessageCorpconversationAsyncsendV2Request.Form>();
                            if (dingdingParams.get((Object)"oaJsonData") != null) {
                                JSONObject oaJsonData = dingdingParams.getJSONObject("oaJsonData");
                                for (String key : oaJsonData.keySet()) {
                                    OapiMessageCorpconversationAsyncsendV2Request.Form e = new OapiMessageCorpconversationAsyncsendV2Request.Form();
                                    if (StringUtils.isNotBlank((CharSequence)key) && !key.startsWith("\u7a7akey")) {
                                        e.setKey(key + ": ");
                                    }
                                    e.setValue(oaJsonData.getString(key));
                                    form.add(e);
                                }
                            }
                            msg.getOa().getBody().setForm(form);
                            msg.getOa().setMessageUrl(linkDdUrl);
                            msg.getOa().setPcMessageUrl(linkPcDdUrl);
                            msg.setMsgtype("oa");
                            request.setMsg(msg);
                        } else if ("card".equals(type)) {
                            msg.setActionCard(new OapiMessageCorpconversationAsyncsendV2Request.ActionCard());
                            msg.getActionCard().setMarkdown(dingdingParams.getString("title"));
                            msg.getActionCard().setSingleTitle(dingdingParams.getString("content"));
                            msg.getActionCard().setSingleUrl(linkDdUrl);
                            msg.setMsgtype("action_card");
                            request.setMsg(msg);
                        } else {
                            msg.setMsgtype("link");
                            msg.setLink(new OapiMessageCorpconversationAsyncsendV2Request.Link());
                            msg.getLink().setTitle(dingdingParams.getString("title"));
                            msg.getLink().setText(dingdingParams.getString("content"));
                            msg.getLink().setMessageUrl(linkDdUrl);
                            msg.getLink().setPicUrl(linkPcDdUrl);
                            request.setMsg(msg);
                        }
                    } else if (dingdingParams.get((Object)"maurl") != null) {
                        msg.setMsgtype("link");
                        msg.setLink(new OapiMessageCorpconversationAsyncsendV2Request.Link());
                        msg.getLink().setTitle(dingdingParams.getString("title"));
                        msg.getLink().setText(dingdingParams.getString("content"));
                        msg.getLink().setMessageUrl(linkDdUrl);
                        msg.getLink().setPicUrl(linkPcDdUrl);
                        request.setMsg(msg);
                    } else {
                        OapiMessageCorpconversationAsyncsendV2Request.Text text = new OapiMessageCorpconversationAsyncsendV2Request.Text();
                        text.setContent(dingdingParams.getString("content"));
                        msg.setText(text);
                        msg.setMsgtype("text");
                        request.setMsg(msg);
                    }
                    OapiMessageCorpconversationAsyncsendV2Response response = (OapiMessageCorpconversationAsyncsendV2Response)client.execute((TaobaoRequest)request, ddAccessToken);
                    JSONObject body = JSONObject.parseObject((String)response.getBody());
                    logger.info("\u53d1\u9001\u9489\u9489\u6d88\u606f\u8fd4\u56de\u7ed3\u679c\uff1a---------\u300b\u300b\u300b\u300b" + response.getBody());
                    if ("0".equals(body.getString("errcode"))) continue;
                    MsgSendResponse msgSendR = new MsgSendResponse("0", "\u9489\u9489\u6d88\u606f\u53d1\u9001\u5931\u8d25:" + body.getString("errmsg"), userVo.getDingdingId());
                    logger.info("\u5411" + userVo.getUserName() + userVo.getDingdingId() + "\u53d1\u9001\u9489\u9489\u6d88\u606f\u5931\u8d25!--->>>" + body.getString("errmsg"));
                    messageResponseList.add(msgSendR);
                }
                catch (ApiException e) {
                    e.printStackTrace();
                    logger.error("\u53d1\u9001\u9489\u9489\u6d88\u606f\u5931\u8d25-------------\u300b\u300b\u300b\u300b\u300b\u300b\uff1a", (Throwable)e);
                }
            }
        }
        return messageResponseList;
    }
}

