/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.util.WeixinRestUtil;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="weixinminprogram")
public class WeixinMinProgramServiceImpl
implements IMsgSendChannelProcessor {
    private static Logger logger = LoggerFactory.getLogger(WeixinMinProgramServiceImpl.class);
    @Autowired
    private IUserApi userApi;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
        JSONObject configJson = null;
        if (StringUtils.isNotBlank((CharSequence)configInfo)) {
            configJson = JSON.parseObject((String)configInfo);
        }
        String appid = configJson.getString("appid");
        String appsecret = configJson.getString("appsecret");
        ArrayList<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
        if (StringUtils.isBlank((CharSequence)appid) || StringUtils.isBlank((CharSequence)appsecret)) {
            logger.info("\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53c2\u6570\u4e3a\u7a7a\uff0cappid-{},appsecret-{}", (Object)appid, (Object)appsecret);
            MsgSendResponse response = new MsgSendResponse("0", "\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53c2\u6570\u4e3a\u7a7a,agentid-" + appid + ",appsecret-" + appsecret);
            messageResponseList.add(response);
            return messageResponseList;
        }
        CommonResponse userResponse = this.userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(), Long.valueOf(Long.parseLong(pushMsgParameter.getTenantId())));
        if (userResponse.isSuccess()) {
            List userVos = (List)userResponse.getData();
            String accessToken = this.getWeixinMinProgramAccessToken(appid, appsecret, false);
            JSONObject minProgramJson = pushMsgParameter.getWeixinMinProgramParams();
            for (UserVO userVo : userVos) {
                String miniprogramState;
                JSONObject wxparams;
                if (StringUtils.isBlank((CharSequence)userVo.getWeixinMinprogramId())) continue;
                JSONObject templateJson = new JSONObject();
                templateJson.put("touser", (Object)userVo.getWeixinMinprogramId());
                templateJson.put("template_id", (Object)minProgramJson.getString("template_id"));
                String page = minProgramJson.getString("page");
                if (StringUtils.isNotBlank((CharSequence)page)) {
                    templateJson.put("page", (Object)page);
                }
                if ((wxparams = minProgramJson.getJSONObject("data")) != null && !wxparams.isEmpty()) {
                    JSONObject wxparamJson = new JSONObject();
                    for (String key : wxparams.keySet()) {
                        JSONObject keyJson = new JSONObject();
                        keyJson.put("value", wxparams.get((Object)key));
                        wxparamJson.put(key, (Object)keyJson);
                    }
                    templateJson.put("data", (Object)wxparamJson);
                }
                if (StringUtils.isNotBlank((CharSequence)(miniprogramState = minProgramJson.getString("miniprogram_state")))) {
                    templateJson.put("miniprogram_state", (Object)miniprogramState);
                }
                templateJson.put("lang", (Object)"zh_CN");
                String templateContent = JSON.toJSONString((Object)templateJson);
                logger.info("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u53d1\u9001\u4fe1\u606f,{}", (Object)templateContent);
                String templateResult = WeixinRestUtil.doPostByURL("https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=" + accessToken, templateContent);
                JSONObject httpResult = JSON.parseObject((String)templateResult);
                if (httpResult != null) {
                    logger.info("weixin_response = " + JSON.toJSONString((Object)httpResult));
                }
                if ("ok".equals(httpResult.get((Object)"errmsg"))) {
                    logger.info("\u5411" + userVo.getWeixinId() + "\u53d1\u9001\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6210\u529f!");
                    continue;
                }
                if ("40001".equals(httpResult.getString("errcode"))) {
                    this.getWeixinMinProgramAccessToken(appid, appsecret, true);
                }
                MsgSendResponse response = new MsgSendResponse("0", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5931\u8d25", userVo.getWeixinId());
                logger.info("\u5411" + userVo.getWeixinId() + "\u53d1\u9001\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u5931\u8d25!");
                messageResponseList.add(response);
            }
        }
        return messageResponseList;
    }

    private String getWeixinMinProgramAccessToken(String appid, String appsecret, boolean reload) {
        String key = appid + "_" + appsecret;
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)key);
        logger.info("redis----accessToken=" + accessToken);
        System.out.println("redis----accessToken=" + accessToken);
        if (StringUtils.isBlank((CharSequence)accessToken) || reload) {
            JSONObject accessJson;
            String accessResult = WeixinRestUtil.doGetByURL("https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + appid + "&secret=" + appsecret, null);
            logger.info("accessResult=" + accessResult);
            System.out.println("accessResult=" + accessResult);
            if (StringUtils.isNotBlank((CharSequence)accessResult) && StringUtils.isNotBlank((CharSequence)(accessToken = (accessJson = JSON.parseObject((String)accessResult)).getString("access_token")))) {
                this.redisTemplate.opsForValue().set((Object)key, (Object)accessToken, 7000L, TimeUnit.SECONDS);
            }
        }
        return accessToken;
    }
}

