package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.foundation.message.util.CdgwSmsUtils;
import com.ejianc.foundation.message.util.ProduceNumber;
import com.ejianc.foundation.message.util.SmsUtils;
import com.ejianc.foundation.message.util.Validate;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springside.modules.nosql.redis.JedisTemplate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("cdgwSmsService")
public class CdgwSmsServiceImpl implements ISmsService {
	private static final Logger logger = LoggerFactory.getLogger(CdgwSmsServiceImpl.class);
	
	@Autowired
	private JedisTemplate jedis;
	
	@Override
	public CommonResponse<String> sendMessage(SmsMessageParam param) {
		logger.debug("发送短信参数：{}", param.toString());
		try {
			if(!Validate.isMobile(param.getPhone())) {
				throw new BusinessException("手机号不合法！");
			}
			Date date = new Date();
			String timeStr = jedis.get(param.getTemplateCode()+param.getPhone()+"time");
			if(StringUtils.isNotBlank(timeStr)) {
				long ltime = Long.parseLong(timeStr);
				if((date.getTime() - ltime) / 1000L < 60L) {
					jedis.setex(param.getTemplateCode()+param.getPhone()+"time", date.getTime()+"", 600);
					return CommonResponse.error("一分钟内不能重复发送");
				}
			}
	        try {
	        	String rand = ProduceNumber.produce();
	        	String content = null;
	        	if(param != null && StringUtils.isNotBlank(param.getTemplateCode()) && !"SMS_463607583".equals(param.getTemplateCode())) {
	        		content = param.getMsgContent();
	        	}else{
	        		content = "验证码："+rand+"（成都国万客服绝对不会索要验证码，切勿告诉他人）,感谢您的支持";
	        	}
	        	List<String> phones = new ArrayList<String>();
	        	phones.add(param.getPhone());
	        	String responseStr = CdgwSmsUtils.sendMsg(phones, content);
	        	logger.info("======"+responseStr);
	            JSONObject responseJson = JSON.parseObject(responseStr);
	            String status = responseJson.getString("resultcode");
	            if("success".equals(status)) {
	            	logger.info("======"+status+":ok");
	            	jedis.setex(param.getTemplateCode()+param.getPhone(), rand, 600);
            		jedis.setex(param.getTemplateCode()+param.getPhone()+"time", date.getTime()+"", 600);
            		
            		return CommonResponse.success("短信发送成功");
	            }
	        } catch (Exception e) {
	        	logger.error(e.getMessage());
	            e.printStackTrace();
	        } 
		} catch(Exception e) {
			logger.error(e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("短信发送失败");
	}

}
