package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.request.OapiMessageCorpconversationSendbytemplateRequest;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.dingtalk.api.response.OapiMessageCorpconversationSendbytemplateResponse;
import com.ejianc.foundation.message.dispatch.IMsgSendChannelProcessor;
import com.ejianc.foundation.message.dispatch.MsgSendResponse;
import com.ejianc.foundation.message.util.WeixinRestUtil;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.foundation.tenant.vo.TenantVO;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.taobao.api.ApiException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Service("ddThirdApp")
public class DdThirdAppServiceImpl implements IMsgSendChannelProcessor {
	private static Logger logger = LoggerFactory.getLogger(DdThirdAppServiceImpl.class);

	@Autowired
	private IUserApi userApi;
	@Autowired
	private ITenantApi tenantApi;
	@Autowired
	private IThirdSystemApi thirdSystemApi;
	@Autowired
	private RedisTemplate<String, Object> redisTemplate;

	@Value("${ejc.dingding.appSecret:https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2}")
	private String sendDdUrl;
	
	@Override
	public List<MsgSendResponse> send(String configInfo, PushMsgParameter pushMsgParameter) {
		JSONObject configJson = null;
		if(StringUtils.isNotBlank(configInfo)) {
			configJson = JSON.parseObject(configInfo);
		}
		String ddAppid = configJson.getString("appid");

		List<MsgSendResponse> messageResponseList = new ArrayList<MsgSendResponse>();
		JSONObject dingdingParams = pushMsgParameter.getDingdingParams();
		//获取钉钉accessToken
		Long tenantId = InvocationInfoProxy.getTenantid()!=null?InvocationInfoProxy.getTenantid():Long.parseLong(pushMsgParameter.getTenantId());
		logger.error("tenantId------------"+tenantId);
		CommonResponse<String> ddAccessTokenResult = thirdSystemApi.getDdThirdAppAccessToken(tenantId);
		CommonResponse<TenantVO> tenantResponse = tenantApi.queryDetail(tenantId);
		String corpid = null;
		if(tenantResponse.isSuccess()&&tenantResponse.getData()!=null){
			corpid = tenantResponse.getData().getCorpid();
		}
		if(StringUtils.isBlank(corpid)){
			logger.error("发送钉钉消息失败,为获取到租户的钉钉企业id------------");
			return messageResponseList;
		}

		String ddAgentid = null;
		CommonResponse<String> agentidResponse = thirdSystemApi.getDdThirdAgentid(corpid);
		if(agentidResponse.isSuccess()&&agentidResponse.getData()!=null){
			ddAgentid = agentidResponse.getData();
		}
		if(StringUtils.isBlank(ddAgentid)){
			logger.error("发送钉钉消息失败,为获取到租户的钉钉企业agentid------------");
			return messageResponseList;
		}

		String ddAccessToken = ddAccessTokenResult.getData();
		logger.info("获取钉钉access Token结果："+ddAccessToken);

		if(StringUtils.isBlank(ddAccessToken)){
			logger.error("发送钉钉消息失败,为获取到钉钉ddAccessToken------------");;
			return messageResponseList;
		}
		CommonResponse<List<UserVO>> userResponse = userApi.queryListByIdsTenantId(pushMsgParameter.getReceivers(),Long.parseLong(pushMsgParameter.getTenantId()));
		if(userResponse.isSuccess()) {
			List<UserVO> userVos = userResponse.getData();
			for(UserVO userVo:userVos) {
				if(StringUtils.isBlank(userVo.getSourceId())) {
					MsgSendResponse response = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "钉钉消息发送失败", userVo.getDingdingId());
					logger.info("向" + userVo.getUserName() + "发送钉钉失败!该用户未绑定钉钉账号！");
					messageResponseList.add(response);
					continue;
				}
				try {
					String linkDdUrl = ("dingtalk://dingtalkclient/action/openapp?corpid="+corpid+"&container_type=work_platform&app_id="+ddAppid+"&redirect_type=jump&redirect_url=");

					String templateId = dingdingParams.getString("templateId");

					DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/sendbytemplate");
					OapiMessageCorpconversationSendbytemplateRequest req = new OapiMessageCorpconversationSendbytemplateRequest();
					req.setAgentId(Long.parseLong(ddAgentid));
					req.setUseridList(userVo.getSourceId());
					req.setTemplateId(templateId);

					JSONObject data = new JSONObject();
					if(dingdingParams.get("type")!=null){
						if("bpmTask".equals(dingdingParams.getString("type"))){
							String maurl = dingdingParams.getString("maurl");
							String pcurl = dingdingParams.getString("pcurl");
							maurl = this.dealUrl(maurl,userVo);
							pcurl = this.dealUrl(pcurl,userVo);
							maurl = linkDdUrl + maurl;
							pcurl = linkDdUrl + pcurl;
							data.put("title",dingdingParams.getString("title"));
							data.put("pcUrl",pcurl);
							data.put("content",dingdingParams.getString("content"));
							data.put("linkUrl",maurl);
							data.put("billTypeName",dingdingParams.getString("billTypeName"));
							data.put("submitUserName",dingdingParams.getString("submitUserName"));
							data.put("approveTime",dingdingParams.getString("approveTime"));
						}else if("bpmNotice".equals(dingdingParams.getString("type"))){
							String maurl = dingdingParams.getString("maurl");
							String pcurl = dingdingParams.getString("pcurl");
							maurl = this.dealUrl(maurl,userVo);
							pcurl = this.dealUrl(pcurl,userVo);
							maurl = linkDdUrl + maurl;
							pcurl = linkDdUrl + pcurl;
							data.put("title",dingdingParams.getString("title"));
							data.put("pcUrl",pcurl);
							data.put("content",dingdingParams.getString("content"));
							data.put("linkUrl",maurl);
							data.put("billTypeName",dingdingParams.getString("billTypeName"));
							data.put("userLabel",dingdingParams.getString("userLabel"));
							data.put("userName",dingdingParams.getString("userName"));
							data.put("timeLabel",dingdingParams.getString("timeLabel"));
							data.put("timeValue",dingdingParams.getString("timeValue"));
						}
					}

					logger.info("动态变量赋值:------------"+data.toJSONString());
					req.setDataString(data.toJSONString());

					OapiMessageCorpconversationSendbytemplateResponse response = client.execute(req, ddAccessToken);
					JSONObject body = JSONObject.parseObject(response.getBody());
					logger.info("发送钉钉消息返回结果：---------》》》》"+response.getBody());
					if("0".equals(body.getString("errcode"))){
						
					}else{
						MsgSendResponse msgSendR = new MsgSendResponse(MsgSendResponse.CODE_SEND_FAILURE, "钉钉消息发送失败:"+body.getString("errmsg"), userVo.getDingdingId());
						logger.info("向" + userVo.getUserName() + userVo.getSourceId() + "发送钉钉消息失败!--->>>"+body.getString("errmsg"));
						messageResponseList.add(msgSendR);
					}
				} catch (ApiException e) {
					e.printStackTrace();
					logger.error("发送钉钉消息失败-------------》》》》》》：",e);;
				}
				
			}
		}
		return messageResponseList;
	}

	public String dealUrl(String url, UserVO userVo) {
		if (url.contains("ddThirdAppid")) {
			url = url.replaceAll("%7BddThirdAppid%7D", userVo.getSourceId()).replaceAll("%7bddThirdAppid%7d", userVo.getSourceId()).replaceAll("\\{ddThirdAppid\\}", userVo.getSourceId());
		} else if (url.contains("userid")) {
			url = url.replaceAll("%7Buserid%7D", userVo.getId().toString()).replaceAll("%7buserid%7d", userVo.getId().toString()).replaceAll("\\{userid\\}", userVo.getId().toString());
		} else {
			if (url.contains("?")) {
				url += ("&userid=" + userVo.getId().toString());
			} else {
				url += ("?userid=" + userVo.getId().toString());
			}
		}
		try {
			url = URLEncoder.encode(url, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return url;
	}
}
