/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.ejianc.foundation.message.config.MessageConfiguration;
import com.ejianc.foundation.message.util.ProduceNumber;
import com.ejianc.foundation.message.util.Validate;
import com.ejianc.foundation.message.vo.SmsCheckParam;
import com.ejianc.foundation.message.vo.SmsMsgSendParam;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springside.modules.nosql.redis.JedisTemplate;

@RestController
@RequestMapping
public class SmsMessageApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisTemplate jedis;
    @Autowired
    private MessageConfiguration messageConfiguration;

    @PostMapping(value={"/api/sms/sendMessage"})
    public com.ejianc.framework.core.response.CommonResponse<String> sendMessage(@RequestBody SmsMsgSendParam param) {
        this.logger.debug("\u53d1\u9001\u77ed\u4fe1\u53c2\u6570\uff1a{}", (Object)param.toString());
        try {
            if (StringUtils.isBlank((CharSequence)param.getTemplateCode())) {
                return com.ejianc.framework.core.response.CommonResponse.error((String)"\u77ed\u4fe1\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!Validate.isMobile(param.getPhone())) {
                return com.ejianc.framework.core.response.CommonResponse.error((String)"\u624b\u673a\u53f7\u4e0d\u5408\u6cd5\uff01");
            }
            Date date = new Date();
            String timeStr = this.jedis.get(param.getTemplateCode() + param.getPhone() + "time");
            if (StringUtils.isNotBlank((CharSequence)timeStr)) {
                long ltime = Long.parseLong(timeStr);
                if ((date.getTime() - ltime) / 1000L < 60L) {
                    this.jedis.setex(param.getTemplateCode() + param.getPhone() + "time", date.getTime() + "", 600);
                    return com.ejianc.framework.core.response.CommonResponse.error((String)"\u4e00\u5206\u949f\u5185\u4e0d\u80fd\u91cd\u590d\u53d1\u9001");
                }
            }
            String rand = ProduceNumber.produce();
            DefaultProfile profile = DefaultProfile.getProfile((String)this.messageConfiguration.getRegionId(), (String)this.messageConfiguration.getAccessKey(), (String)this.messageConfiguration.getSecret());
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            CommonRequest commonRequest = new CommonRequest();
            commonRequest.setSysMethod(MethodType.POST);
            commonRequest.setSysDomain(this.messageConfiguration.getSysDomain());
            commonRequest.setSysVersion(this.messageConfiguration.getSysVersion());
            commonRequest.setSysAction(this.messageConfiguration.getSysAction());
            commonRequest.putQueryParameter("RegionId", this.messageConfiguration.getRegionId());
            commonRequest.putQueryParameter("PhoneNumbers", param.getPhone());
            commonRequest.putQueryParameter("SignName", StringUtils.isNotBlank((CharSequence)param.getSignName()) ? param.getSignName() : "\u76ca\u4f01\u5de5\u7a0b\u4e91");
            commonRequest.putQueryParameter("TemplateCode", param.getTemplateCode());
            Map templateParam = param.getParams();
            templateParam.put("code", rand);
            commonRequest.putQueryParameter("TemplateParam", JSON.toJSONString((Object)templateParam));
            try {
                CommonResponse response = client.getCommonResponse(commonRequest);
                String result = response.getData();
                if (StringUtils.isNotBlank((CharSequence)result)) {
                    JSONObject resultJson = JSON.parseObject((String)result);
                    if ("OK".equals(resultJson.getString("Code"))) {
                        this.jedis.setex(param.getTemplateCode() + param.getPhone(), rand, 600);
                        this.jedis.setex(param.getTemplateCode() + param.getPhone() + "time", date.getTime() + "", 600);
                        return com.ejianc.framework.core.response.CommonResponse.success((String)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
                    }
                    String errorMsg = resultJson.getString("Message");
                    return com.ejianc.framework.core.response.CommonResponse.error((String)errorMsg);
                }
            }
            catch (ServerException e) {
                this.logger.error("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38,", (Throwable)e);
            }
            catch (ClientException e) {
                this.logger.error("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38,", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38,", (Throwable)e);
        }
        return com.ejianc.framework.core.response.CommonResponse.error((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
    }

    @PostMapping(value={"/api/sms/checkMessage"})
    public com.ejianc.framework.core.response.CommonResponse<String> checkMessage(@RequestBody SmsCheckParam param) {
        this.logger.debug("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c\u53c2\u6570 - param\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        try {
            String phone = param.getPhone();
            String templateCode = param.getTemplateCode();
            String validate = param.getValidate();
            if (StringUtils.isBlank((CharSequence)templateCode)) {
                return com.ejianc.framework.core.response.CommonResponse.error((String)"\u6d88\u606f\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)phone)) {
                return com.ejianc.framework.core.response.CommonResponse.error((String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)validate)) {
                return com.ejianc.framework.core.response.CommonResponse.error((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String ran = this.jedis.get(templateCode + phone);
            if (StringUtils.isBlank((CharSequence)ran)) {
                return com.ejianc.framework.core.response.CommonResponse.error((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff01");
            }
            if (validate.equals(ran)) {
                this.jedis.del(new String[]{templateCode + phone});
                return com.ejianc.framework.core.response.CommonResponse.success((String)"\u77ed\u4fe1\u9a8c\u8bc1\u6210\u529f");
            }
            return com.ejianc.framework.core.response.CommonResponse.error((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u4e4b\u540e\u91cd\u65b0\u8f93\u5165\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c - param, \u5f02\u5e38\uff1a{}", (Object)JSONObject.toJSONString((Object)param), (Object)e);
            return com.ejianc.framework.core.response.CommonResponse.error((String)"\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2\u662f\u5426\u5408\u6cd5");
        }
    }
}

