/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.controller.param.SmsMessageParam;
import com.ejianc.foundation.message.service.ISmsService;
import com.ejianc.foundation.message.util.ProduceNumber;
import com.ejianc.foundation.message.util.Validate;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springside.modules.nosql.redis.JedisTemplate;

@Service(value="zdsSmsService")
public class ZdsSmsServiceImpl
implements ISmsService {
    private static final Logger logger = LoggerFactory.getLogger(ZdsSmsServiceImpl.class);
    @Autowired
    private JedisTemplate jedis;
    @Value(value="${ejc.sms.zds.host:0}")
    private String smsHost;
    @Value(value="${ejc.sms.zds.appid:0}")
    private String appid;
    @Value(value="${ejc.sms.zds.secret:0}")
    private String secret;

    @Override
    public CommonResponse<String> sendMessage(SmsMessageParam param) {
        logger.info("\u53d1\u9001\u77ed\u4fe1\u53c2\u6570\uff1a{}", (Object)param.toString());
        try {
            if (StringUtils.isBlank((CharSequence)param.getTemplateCode())) {
                return CommonResponse.error((String)"\u77ed\u4fe1\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)param.getSignName())) {
                return CommonResponse.error((String)"\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!Validate.isMobile(param.getPhone())) {
                return CommonResponse.error((String)"\u624b\u673a\u53f7\u4e0d\u5408\u6cd5\uff01");
            }
            try {
                String rand = null != param.getParams() && null != param.getParams().get("rand") ? param.getParams().get("rand") : ProduceNumber.produce();
                String ticket = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, String> headers = new HashMap<String, String>();
                Map<String, String> paramP = param.getParams();
                JSONObject templateInfo = new JSONObject();
                if (paramP != null) {
                    for (String s : paramP.keySet()) {
                        templateInfo.put(s, (Object)paramP.get(s));
                    }
                }
                templateInfo.put("code", (Object)rand);
                params.put("signName", param.getSignName());
                params.put("phoneNumbers", param.getPhone());
                params.put("templateCode", param.getTemplateCode());
                params.put("templateInfo", templateInfo.toJSONString());
                params.put("modelName", "\u76ca\u4f01\u8054\u7cfb\u7edf");
                params.put("name", "00000000-0000-0000-0000-000000000000");
                headers.put("appid", this.appid);
                headers.put("ticket", ticket);
                headers.put("sign", ZdsSmsServiceImpl.toMD5(this.secret + ticket + this.secret));
                logger.info("\u77ed\u4fe1\u53d1\u9001\u53c2\u6570: param={} headers={}", (Object)JSONObject.toJSONString(params), (Object)JSONObject.toJSONString(headers));
                String result = HttpTookit.get((String)this.smsHost, params, headers);
                if (StringUtils.isNotBlank((CharSequence)result)) {
                    JSONObject resultJson = JSON.parseObject((String)result);
                    if ("ok".equals(resultJson.getString("status"))) {
                        logger.info("\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01{} - {}", (Object)param.getPhone(), (Object)rand);
                        this.jedis.setex(param.getTemplateCode() + param.getPhone(), rand, 600);
                        return CommonResponse.success((String)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01");
                    }
                    String errorMsg = resultJson.getString("info");
                    logger.info("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01{}", (Object)result);
                    return CommonResponse.error((String)errorMsg);
                }
                logger.info("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01{}-\u54cd\u5e94\u4e3a\u7a7a", (Object)result);
            }
            catch (Exception e) {
                logger.error("\u6839\u636e\u53c2\u6570[{}]-\u53d1\u9001\u77ed\u606f\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)param));
                logger.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38", (Throwable)e);
            }
        }
        catch (Exception ex) {
            logger.error("\u6839\u636e\u53c2\u6570[{}]-\u53d1\u9001\u77ed\u606f\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)param));
            logger.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38", (Throwable)ex);
        }
        return CommonResponse.error((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
    }

    private static String toMD5(String plainText) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }
}

