package com.ejianc.business.oa.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 这个VO是和施工周报相关的接口的VO
 * 作用是：存储开工报告、年度指标计划、收款登记、施工合同、施工周报相关里面的数据
 * 存储的数据如下
 * 1.开工报告：开工日期（开工报告）、开工日期（实际开工）、竣工日期（按开工报告）、竣工日期（按实际开工）、是否办理开工报告
 * 2.年度指标计划：年度指标计划
 * 3.收款登记：累计收款
 * 4.施工合同：合同总金额
 * 5.施工周报：选择项目的最新周报日期
 */
public class WeeklyReportRelatedVO {
    // 项目立项相关
    private Long projectId; // 项目ID
    // 开工报告相关
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startWorkDate; // 开工日期(按开工报告)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualStartWorkDate; // 开工日期(按实际开工)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionDateByReport; // 竣工日期(按开工报告)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completionDateByActualStart; // 竣工日期(按实际开工)
    private Integer report; // 是否办理开工报告
    // 年度指标计划相关
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEndDate; // 计划完工日期
    // 收款登记
    private BigDecimal sumCollectHaveThisMny; // 累计收款金额
    // 施工合同
    private BigDecimal contractTaxMny; // 合同总金额
    // 施工周报
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date maxStatisticsDate; // 该项目的最新一次周报日期

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getStartWorkDate() {
        return startWorkDate;
    }

    public void setStartWorkDate(Date startWorkDate) {
        this.startWorkDate = startWorkDate;
    }

    public Date getActualStartWorkDate() {
        return actualStartWorkDate;
    }

    public void setActualStartWorkDate(Date actualStartWorkDate) {
        this.actualStartWorkDate = actualStartWorkDate;
    }

    public Date getCompletionDateByReport() {
        return completionDateByReport;
    }

    public void setCompletionDateByReport(Date completionDateByReport) {
        this.completionDateByReport = completionDateByReport;
    }

    public Date getCompletionDateByActualStart() {
        return completionDateByActualStart;
    }

    public void setCompletionDateByActualStart(Date completionDateByActualStart) {
        this.completionDateByActualStart = completionDateByActualStart;
    }

    public Integer getReport() {
        return report;
    }

    public void setReport(Integer report) {
        this.report = report;
    }

    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    public BigDecimal getSumCollectHaveThisMny() {
        return sumCollectHaveThisMny;
    }

    public void setSumCollectHaveThisMny(BigDecimal sumCollectHaveThisMny) {
        this.sumCollectHaveThisMny = sumCollectHaveThisMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public Date getMaxStatisticsDate() {
        return maxStatisticsDate;
    }

    public void setMaxStatisticsDate(Date maxStatisticsDate) {
        this.maxStatisticsDate = maxStatisticsDate;
    }
}