package com.ejianc.business.oa.api;

import com.ejianc.business.oa.hystrix.WeeklyReportHystrix;
import com.ejianc.business.oa.vo.WeeklyReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "ejc-oa-web", url = "${common.env.feign-client-url}", path = "ejc-oa-web", fallback = WeeklyReportHystrix.class)
public interface IWeeklyReportApi {
    /**
     * 根据项目查询最近的周报
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/api/weeklyReport/queryLatest", method = RequestMethod.GET)
    CommonResponse<WeeklyReportVO> queryLatest(@RequestParam(value = "projectId") Long projectId);

}
