package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.oa.vo.CALockRegisterDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * CA锁登记主实体
 * 
 * @author generator
 * 
 */
public class CALockRegisterVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private String caLockName; // CA锁名称
    private String caLockType; // CA锁类型
    private Long headId; // 负责人
    private String headName; // 负责人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date expiryDate; // 有效期至
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date remindDate; // 提醒日期
    private Integer startFlag; // 是否启用 0-否、1-是
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称

    private String billStateName; // 单据状态名称
    private String startFlagName; // 状态 是否启用 0-否、1-是
    
    private List<CALockRegisterDetailVO> detailList = new ArrayList<>(); // CA锁登记-子实体

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getCaLockName() {
        return caLockName;
    }

    public void setCaLockName(String caLockName) {
        this.caLockName = caLockName;
    }
    public String getCaLockType() {
        return caLockType;
    }

    public void setCaLockType(String caLockType) {
        this.caLockType = caLockType;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getHeadId() {
        return headId;
    }
    @ReferDeserialTransfer
    public void setHeadId(Long headId) {
        this.headId = headId;
    }
    public String getHeadName() {
        return headName;
    }

    public void setHeadName(String headName) {
        this.headName = headName;
    }
    public Date getExpiryDate() {
        return expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }
    public Date getRemindDate() {
        return remindDate;
    }

    public void setRemindDate(Date remindDate) {
        this.remindDate = remindDate;
    }
    public Integer getStartFlag() {
        return startFlag;
    }

    public void setStartFlag(Integer startFlag) {
        this.startFlag = startFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getStartFlagName() {
        return startFlagName;
    }

    public void setStartFlagName(String startFlagName) {
        this.startFlagName = startFlagName;
    }

    public List<CALockRegisterDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CALockRegisterDetailVO> detailList) {
        this.detailList = detailList;
    }
}
