package com.ejianc.business.oa.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;  // MyBatis-Plus 分页结果接口
import com.ejianc.business.oa.query.WeeklyProjectRelatedQuery;  // 查询参数对象（DTO）
// 原来如此，后面代码里面的注解都是在上面用import引用的，
import com.ejianc.business.oa.vo.WeeklyProjectRelatedVO;
import org.apache.ibatis.annotations.Mapper;  // 标识MyBatis的Mapper接口
import org.apache.ibatis.annotations.Param;  // SQL参数绑定注解

import java.util.List;  // 列表接口


/**
 * 这个接口是和施工周报相关的接口
 * 作用是：获取该项目在“项目责任分工”下子表的数据
 * 存储的数据如下
 * 项目责任分工：子表数据的id、姓名、工号、职级、项目职务、2.0责任分工、是否区域主管
 */
@Mapper
public interface WeeklyProjectRelatedMapper {

    List<WeeklyProjectRelatedVO> queryWeeklyProjectRelatedList(@Param("page") IPage<WeeklyProjectRelatedVO> page, @Param("query")WeeklyProjectRelatedQuery query);

}