package com.ejianc.business.oa.query;

import java.util.ArrayList;
import java.util.List;


/**
 * 这个Query是和施工周报相关的接口的Query
 * 作用是：存储开工报告、年度指标计划、收款登记、施工合同、施工周报相关里面的数据
 * Query里面的值：1.数据隔离，2.分页参数、3.给sql语句传递的值projectCode--项目编码
 * 相关的数据如下
 * 1.开工报告：开工日期（开工报告）、开工日期（实际开工）、竣工日期（按开工报告）、竣工日期（按实际开工）、是否办理开工报告
 * 2.年度指标计划：年度指标计划
 * 3.收款登记：累计收款
 * 4.施工合同：合同总金额
 * 5.施工周报：选择项目的最新周报日期
 */
public class WeeklyReportRelatedQuery {
    // 数据隔离
    private Long tenantId;
    private List<Long> orgIdList = new ArrayList<>();

    //分页
    private Integer pageNum = 1; // 起始页
    private Integer pageSize = 10; // 每页大小
    private Boolean disAblePage = false; // 是否禁用分页

    // 做筛选用
    private String projectCode; // 项目编码

    //-------------分割线------------------------------------
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public List<Long> getOrgIdList() {
        return orgIdList;
    }

    public void setOrgIdList(List<Long> orgIdList) {
        this.orgIdList = orgIdList;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Boolean getDisAblePage() {
        return disAblePage;
    }

    public void setDisAblePage(Boolean disAblePage) {
        this.disAblePage = disAblePage;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
}