package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.CertApplyDetailEntity;
import com.ejianc.business.oa.vo.CertApplyListVO;
import com.ejianc.business.oa.vo.CertApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.CertApplyMapper;
import com.ejianc.business.oa.bean.CertApplyEntity;
import com.ejianc.business.oa.service.ICertApplyService;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 证照使用申请实体
 * 
 * @author generator
 * 
 */
@Service("certApplyService")
public class CertApplyServiceImpl extends BaseServiceImpl<CertApplyMapper, CertApplyEntity> implements ICertApplyService{
    private static final String CERT_APPLY_BILL_CODE = "CERT_APPLY";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<CertApplyVO> saveOrUpdate(CertApplyVO certApplyVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        CertApplyEntity entity = null;
        String operateType = null;
        if(StringUtils.isEmpty(certApplyVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(CERT_APPLY_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                certApplyVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity = BeanMapper.map(certApplyVO, CertApplyEntity.class);

        //汇总证照明细名称
        List<CertApplyDetailEntity> applyDetail = entity.getCertApplyDetail();
        String certName = "";
        if(applyDetail != null && applyDetail.size() > 0){
            List<String> certNameList = applyDetail.stream().filter(e->(e.getRowState()==null)||!(e.getRowState().equals("del"))).map(CertApplyDetailEntity::getCertName).collect(Collectors.toList());
            //去重
            List<String> certNames = certNameList.stream().distinct().collect(Collectors.toList());
            for(String cert : certNames){
                certName = certName + cert + ",";
            }
            String substring = certName.substring(0, certName.length() - 1);
            entity.setCertName(substring);
            entity.setApplyNum(certNameList.size());
        }
        super.saveOrUpdate(entity,false);
        return CommonResponse.success(BeanMapper.map(entity, CertApplyVO.class));
    }

    @Override
    public List<CertApplyListVO> getDealList(Page<CertApplyListVO> page, QueryWrapper wrapper) {

        List<CertApplyListVO> list = baseMapper.getDealList(page, wrapper);
        return list;
    }

}
