package com.ejianc.business.oa.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.oa.vo.CALockRegisterDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.oa.bean.CALockRegisterEntity;
import com.ejianc.business.oa.service.ICALockRegisterService;
import com.ejianc.business.oa.vo.CALockRegisterVO;

/**
 * CA锁登记主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("caLockRegister")
public class CALockRegisterController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "CA_LOCK_REGISTER";//此处需要根据实际修改


    @Autowired
    private ICALockRegisterService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CALockRegisterVO> saveOrUpdate(@RequestBody CALockRegisterVO saveOrUpdateVO) {
    	CALockRegisterEntity entity = BeanMapper.map(saveOrUpdateVO, CALockRegisterEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	CALockRegisterVO vo = BeanMapper.map(entity, CALockRegisterVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CALockRegisterVO> queryDetail(Long id) {
    	CALockRegisterEntity entity = service.selectById(id);
    	CALockRegisterVO vo = BeanMapper.map(entity, CALockRegisterVO.class);
    	vo.getDetailList().sort(Comparator.comparing(CALockRegisterDetailVO::getCreateTime).reversed());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CALockRegisterVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CALockRegisterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CALockRegisterVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CALockRegisterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("caLockName");
        fuzzyFields.add("caLockType");
        fuzzyFields.add("headName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
//        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
//            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
//        } else {
//            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
//                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        }

        IPage<CALockRegisterEntity> page = service.queryPage(param,false);
        IPage<CALockRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CALockRegisterVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("caLockName");
        fuzzyFields.add("caLockType");
        fuzzyFields.add("headName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
//        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
//            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
//        } else {
//            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
//                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        }
        List<CALockRegisterEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<CALockRegisterVO> voList = BeanMapper.mapList(list, CALockRegisterVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            e.setStartFlagName(0 == e.getStartFlag() ? "停用" : "启用");
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("CALockRegister-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCALockRegisterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CALockRegisterVO>> refCALockRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("caLockName");
        fuzzyFields.add("caLockType");
        fuzzyFields.add("headName");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        param.getParams().put("startFlag", new Parameter(QueryParam.EQ, 1));

        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));

        IPage<CALockRegisterEntity> page = service.queryPage(param,false);
        IPage<CALockRegisterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());


        List<CALockRegisterVO> voList = BeanMapper.mapList(page.getRecords(), CALockRegisterVO.class);
        voList.forEach(e -> {
            e.setStartFlagName(0 == e.getStartFlag() ? "停用" : "启用");
        });
        pageData.setRecords(voList);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * @Description updateStartFlag 修改状态
     * @param id
     */
    @RequestMapping(value = "/updateStartFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateStartFlag(Long id, int startFlag) {
        LambdaUpdateWrapper<CALockRegisterEntity> updateRecordWrapper = new LambdaUpdateWrapper<>();
        updateRecordWrapper.eq(CALockRegisterEntity::getId, id);
        updateRecordWrapper.set(CALockRegisterEntity::getStartFlag, startFlag);
        Boolean updateFlag = service.update(updateRecordWrapper);
        return CommonResponse.success(!!updateFlag ? "修改单据状态成功！" : "修改单据状态失败！");
    }



    /**
     * 发消息--CA锁到期提醒
     * 每天早上8点查询所有生效的CA锁登记单据，当前日期=提醒日期的，给负责人、经办人发送系统消息
     * @return
     */
    @RequestMapping(value = "/sendCAMsgToPerson", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> sendCAMsgToPerson(HttpServletRequest request) {
        String msgSendResult = service.sendCAMsgToPerson();
        return CommonResponse.success("CA锁到期提醒发送信息成功！", msgSendResult);
    }

}
