package com.ejianc.business.oa.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.oa.bean.MonthBudgetFormDetailEntity;
/**
 * 月度收支填报主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_month_budget_form")
public class MonthBudgetFormEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="month")
    private Date month; // 月份
    @TableField(value="total_unit_social_security_mny")
    private BigDecimal totalUnitSocialSecurityMny; // 单位社保金额
    @TableField(value="total_person_social_security_mny")
    private BigDecimal totalPersonSocialSecurityMny; // 个人社保金额
    @TableField(value="total_pay_mny")
    private BigDecimal totalPayMny; // 支出金额
    @TableField(value="total_income_mny")
    private BigDecimal totalIncomeMny; // 收入金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="monthBudgetFormDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<MonthBudgetFormDetailEntity> detailList = new ArrayList<>(); // 月度收支填报-子实体
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public BigDecimal getTotalUnitSocialSecurityMny() {
        return totalUnitSocialSecurityMny;
    }

    public void setTotalUnitSocialSecurityMny(BigDecimal totalUnitSocialSecurityMny) {
        this.totalUnitSocialSecurityMny = totalUnitSocialSecurityMny;
    }
    public BigDecimal getTotalPersonSocialSecurityMny() {
        return totalPersonSocialSecurityMny;
    }

    public void setTotalPersonSocialSecurityMny(BigDecimal totalPersonSocialSecurityMny) {
        this.totalPersonSocialSecurityMny = totalPersonSocialSecurityMny;
    }
    public BigDecimal getTotalPayMny() {
        return totalPayMny;
    }

    public void setTotalPayMny(BigDecimal totalPayMny) {
        this.totalPayMny = totalPayMny;
    }
    public BigDecimal getTotalIncomeMny() {
        return totalIncomeMny;
    }

    public void setTotalIncomeMny(BigDecimal totalIncomeMny) {
        this.totalIncomeMny = totalIncomeMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public List<MonthBudgetFormDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<MonthBudgetFormDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
