package com.ejianc.business.oa.controller;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.SealApplyEntity;
import com.ejianc.business.oa.service.ISealApplyService;
import com.ejianc.business.oa.vo.SealApplyExportVO;
import com.ejianc.business.oa.vo.SealApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;

/**
 * 用印申请实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("sealApply")
public class SealApplyController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "seal-use-code001";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISealApplyService service; 
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    // 用印申请数据权限白名单角色配置
    private static final String PARAM_VIEW_CODE = "P-1392GB56";

    @Autowired
    private IRoleApi roleApi;

    @Autowired
    private IParamConfigApi paramConfigApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SealApplyVO> saveOrUpdate(@RequestBody SealApplyVO saveorUpdateVO) {
        SealApplyVO vo =service.insertOrUpdate(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SealApplyVO> queryDetail(Long id) {
        SealApplyVO vo= service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SealApplyVO> vos) {
        service.removeByIds(vos.stream().map(SealApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SealApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("fileName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("deptName");
        fuzzyFields.add("applier");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);
        if (StringUtils.isNotEmpty(authOrgIds)){
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong)
                            .collect(Collectors.toList()));
            param.getParams().put("orgId",new Parameter("in",authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }else{
            param.getParams().put("orgId",new Parameter("in",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        // 判断当前用户是否可以查看所有的用印申请
        if (!canViewAll()) {
            /** 用户隔离 */
            param.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
        }
        IPage<SealApplyEntity> page = service.queryPage(param,false);
        IPage<SealApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SealApplyVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @description: 根据当前用户角色判断是都可以查看用印申请
     * @return: java.lang.Boolean
     * @author songlx
     * @date: 2022/7/26
     */
    public Boolean canViewAll() {
        CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            if (StringUtils.isNotEmpty(valueData)) {
                Long userid = InvocationInfoProxy.getUserid();
                CommonResponse<List<RoleVO>> roleRes = roleApi.queryRoleByUserId(userid);
                if (roleRes.isSuccess() && CollectionUtils.isNotEmpty(roleRes.getData())) {
                    List<String> valList = Arrays.asList(valueData.split(",|，"));
                    for (RoleVO roleVO : roleRes.getData()) {
                        if (valList.contains(roleVO.getCode()))
                            return Boolean.TRUE;
                    }
                }
            }
        }
        return Boolean.FALSE;
    }
    
    /**
     * @Author liyongjia
     * @Date 2020/6/10 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageIndex(0);
        queryParam.setPageSize(100000);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("fileName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("deptName");
        fuzzyFields.add("applier");

        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        // 判断当前用户是否可以查看所有的用印申请
        if (!canViewAll()) {
            /** 用户隔离 */
            queryParam.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));
        }

        IPage<SealApplyEntity>  voPage = service.queryPage(queryParam,false);
        List<SealApplyEntity> list = voPage.getRecords();
        List<SealApplyExportVO> exportVOS = new ArrayList<>();
        list.forEach(vo -> {
        	SealApplyExportVO exportVO = BeanMapper.map(vo, SealApplyExportVO.class);
            if(vo.getApplyDate()!=null){
            	exportVO.setApplyDate(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getApplyDate()));
			}
			exportVO.setBillState(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            exportVOS.add(exportVO);
        });
        
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        String fileName = "sealApplyExport.xlsx";
        
        ExcelExport.getInstance().export(fileName, beans, response);
    }
	
}
