package com.ejianc.business.oa.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;  // MyBatis-Plus 分页结果接口
import com.ejianc.business.oa.query.WeeklyReportCollectionQuery;  // 查询参数对象（DTO）
import com.ejianc.business.oa.vo.WeeklyReportCollectionVO;  // 视图对象（VO）
// 原来如此，后面代码里面的注解都是在上面用import引用的，
import org.apache.ibatis.annotations.Mapper;  // 标识MyBatis的Mapper接口
import org.apache.ibatis.annotations.Param;  // SQL参数绑定注解

import java.util.List;  // 列表接口


/**
 * 这个接口是和施工周报相关的接口
 * 作用是：收款登记的下面项目的所有的收款相关，然后把数据交给前端来处理
 * 相关的数据如下
 * 收款登记：此项目的项目ID、该项目每个单据的办理时间、该项目每个单据的收款金额
 */
@Mapper
public interface WeeklyReportCollectionMapper {

    // 项目责任分工报表
    List<WeeklyReportCollectionVO> queryWeeklyReportCollectionList(@Param("page") IPage<WeeklyReportCollectionVO> page, @Param("query")WeeklyReportCollectionQuery query);

}