package com.ejianc.business.oa.service;

// 第三方库导入
import com.baomidou.mybatisplus.core.metadata.IPage;
// 项目内部导入
import com.ejianc.business.oa.query.WeeklyReportRelatedQuery;
import com.ejianc.business.oa.vo.WeeklyReportRelatedVO;

/**
 * 这个Service是和施工周报相关的接口的Service
 * 作用是：存储开工报告、年度指标计划、收款登记、施工合同、施工周报相关里面的数据
 * 相关的数据如下
 * 1.开工报告：开工日期（开工报告）、开工日期（实际开工）、竣工日期（按开工报告）、竣工日期（按实际开工）、是否办理开工报告
 * 2.年度指标计划：年度指标计划
 * 3.收款登记：累计收款
 * 4.施工合同：合同总金额
 * 5.施工周报：选择项目的最新周报日期
 */
// 代码解释在代码后面，这样不会破坏代码结构
public interface IWeeklyReportRelatedService {

    IPage<WeeklyReportRelatedVO> queryWeeklyReportRelatedList(WeeklyReportRelatedQuery query);


}