package com.ejianc.business.procBid.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.procBid.bean.ProcBidApprovalDetailEntity;
/**
 * 物资设备类定标会签-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proc_bid_approval")
public class ProcBidApprovalEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="purchase_id")
    private Long purchaseId; // 采购事项ID
    @TableField(value="purchase_code")
    private String purchaseCode; // 采购事项CODE
    @TableField(value="purchase_name")
    private String purchaseName; // 采购事项NAME
    @TableField(value="winning_mny")
    private BigDecimal winningMny; // 中标金额(预估标的物金额)
    @TableField(value="proc_type")
    private String procType; // 招采类型
    @TableField(value="proc_method")
    private String procMethod; // 招采类型
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="procBidApprovalDetailService")
    private List<ProcBidApprovalDetailEntity> detailList = new ArrayList<>(); // 物资设备类定标会签-子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(Long purchaseId) {
        this.purchaseId = purchaseId;
    }
    public String getPurchaseCode() {
        return purchaseCode;
    }

    public void setPurchaseCode(String purchaseCode) {
        this.purchaseCode = purchaseCode;
    }
    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    public BigDecimal getWinningMny() {
        return winningMny;
    }

    public void setWinningMny(BigDecimal winningMny) {
        this.winningMny = winningMny;
    }
    public String getProcType() {
        return procType;
    }

    public void setProcType(String procType) {
        this.procType = procType;
    }
    public String getProcMethod() {
        return procMethod;
    }

    public void setProcMethod(String procMethod) {
        this.procMethod = procMethod;
    }


    public List<ProcBidApprovalDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ProcBidApprovalDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
