/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.CertRecordEntity;
import com.ejianc.business.oa.bean.ManagementEntity;
import com.ejianc.business.oa.service.ICertRecordService;
import com.ejianc.business.oa.service.IManagementService;
import com.ejianc.business.oa.vo.CertRecordListVO;
import com.ejianc.business.oa.vo.CertRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"certRecord"})
public class CertRecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICertRecordService service;
    @Autowired
    private IManagementService managementService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @RequestMapping(value={"/applySaveRecord"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CertRecordVO> applySaveRecord(@RequestBody CertRecordVO saveorUpdateVO) {
        return this.service.applySaveRecord(saveorUpdateVO);
    }

    @RequestMapping(value={"/manageSaveRecord"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CertRecordVO> manageSaveRecord(@RequestBody CertRecordVO saveorUpdateVO) {
        return this.service.manageSaveRecord(saveorUpdateVO);
    }

    @RequestMapping(value={"/manageUpdateRecord"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CertRecordVO> manageUpdateRecord(@RequestBody CertRecordVO saveorUpdateVO) {
        return this.service.manageUpdateRecord(saveorUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CertRecordVO> queryDetail(Long id) {
        CertRecordEntity entity = (CertRecordEntity)((Object)this.service.selectById(id));
        CertRecordVO vo = (CertRecordVO)BeanMapper.map((Object)((Object)entity), CertRecordVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getLastOptTime"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CertRecordVO> getLastOptTime(Long id) {
        LambdaQueryWrapper wrapperCertRecord = Wrappers.lambdaQuery();
        wrapperCertRecord.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapperCertRecord.in(CertRecordEntity::getCertId, new Object[]{id});
        wrapperCertRecord.eq(CertRecordEntity::getOptType, (Object)1);
        wrapperCertRecord.orderByDesc(BaseEntity::getCreateTime);
        List certRecordList = this.service.list((Wrapper)wrapperCertRecord);
        CertRecordEntity certRecordEntity = null;
        if (ListUtil.isNotEmpty((List)certRecordList)) {
            certRecordEntity = (CertRecordEntity)((Object)certRecordList.get(0));
            CertRecordVO vo = (CertRecordVO)BeanMapper.map((Object)((Object)certRecordEntity), CertRecordVO.class);
            ManagementEntity managementEntity = (ManagementEntity)((Object)this.managementService.selectById(id));
            vo.setAddr(managementEntity.getStorageLocation());
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
        }
        certRecordEntity = new CertRecordEntity();
        CertRecordVO vo = (CertRecordVO)BeanMapper.map((Object)((Object)certRecordEntity), CertRecordVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CertRecordVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/deleteById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteById(@RequestBody CertRecordVO vo) {
        this.service.deleteById(vo);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getOutList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> getOutList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("certName");
        fuzzyFields.add("certCode");
        fuzzyFields.add("userName");
        fuzzyFields.add("memo");
        fuzzyFields.add("certTypeName");
        fuzzyFields.add("receiveCompanyName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("certTypeIdOrg")) {
            Parameter certTypeIdOrgPar = (Parameter)param.getParams().get("certTypeIdOrg");
            if (param.getParams().containsKey("certTypeId")) {
                Parameter certTypeIdPar = (Parameter)param.getParams().get("certTypeId");
                String certTypeId = certTypeIdPar.getValue().toString();
                String certTypeIdOrg = certTypeIdOrgPar.getValue().toString();
                certTypeIdOrgPar.setValue((Object)((String)certTypeIdOrg + "," + certTypeId));
            }
            param.getParams().put("certTypeId", certTypeIdOrgPar);
            param.getParams().remove("certTypeIdOrg");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<CertRecordListVO> list = this.service.getOutList((Page<CertRecordListVO>)page, wrapper);
        for (CertRecordListVO certApplyListVO : list) {
            Date date = new Date();
            long l = (certApplyListVO.getReturnTime().getTime() - date.getTime()) / 86400000L;
            String returnDay = null;
            returnDay = l >= 0L ? l + "\u5929" : "\u5ef6\u671f" + l;
            certApplyListVO.setReturnDay(returnDay);
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", (Object)page.getTotal());
        res.put("current", (Object)page.getCurrent());
        res.put("size", (Object)page.getSize());
        res.put("pages", (Object)page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CertRecordVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("useTime", "");
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List recordIds = null;
        if (ListUtil.isNotEmpty((List)page.getRecords())) {
            recordIds = page.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        List certRecordVOS = BeanMapper.mapList((Iterable)page.getRecords(), CertRecordVO.class);
        if (ListUtil.isNotEmpty(recordIds)) {
            JSONObject paramStr = new JSONObject();
            paramStr.put("sourceIds", recordIds);
            paramStr.put("orderType", (Object)"asc");
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(paramStr);
            if (listCommonResponse.isSuccess()) {
                List data = (List)listCommonResponse.getData();
                if (ListUtil.isNotEmpty((List)data)) {
                    for (CertRecordVO certRecordVO : certRecordVOS) {
                        ArrayList<AttachmentVO> attachmentVOS = new ArrayList<AttachmentVO>();
                        ArrayList<Long> attachIds = new ArrayList<Long>();
                        for (AttachmentVO attachmentVO : data) {
                            if (certRecordVO.getId().equals(attachmentVO.getSourceId())) {
                                attachmentVOS.add(attachmentVO);
                                attachIds.add(attachmentVO.getId());
                            }
                            certRecordVO.setAttachmentVOList(attachmentVOS);
                            certRecordVO.setAttachIds(attachIds);
                        }
                    }
                }
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        Integer a = 0;
        for (CertRecordVO certRecordVO : certRecordVOS) {
            certRecordVO.setType(a);
            a = a + 1;
        }
        pageData.setRecords(certRecordVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

