package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.oa.vo.ImportMonthBudgetFormDetailVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.MonthBudgetFormMapper;
import com.ejianc.business.oa.bean.MonthBudgetFormEntity;
import com.ejianc.business.oa.service.IMonthBudgetFormService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * 月度收支填报主实体
 * 
 * @author generator
 * 
 */
@Service("monthBudgetFormService")
public class MonthBudgetFormServiceImpl extends BaseServiceImpl<MonthBudgetFormMapper, MonthBudgetFormEntity> implements IMonthBudgetFormService{

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private IEmployeeApi employeeApi;


    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }



        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportMonthBudgetFormDetailVO> successList = new ArrayList<>();
            List<ImportMonthBudgetFormDetailVO> errorList = new ArrayList<>();

            //项目Map
            Map<String, ProjectRegisterVO> projectMap = new HashMap<>();
            QueryParam queryProjectParam = new QueryParam();
            //人员Map
            Map<String, EmployeeVO> employeeMap = new HashMap<>();

            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 10) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size()>=1000){
                    throw new BusinessException("文件数据不能超过1000行，超过请分批次多次导入");
                }

                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    ImportMonthBudgetFormDetailVO importVO = new ImportMonthBudgetFormDetailVO();




                    //员工编码-personCode
                    if (StringUtils.isNotBlank(datas.get(0))) {
                        importVO.setPersonCode(datas.get(0).trim());
                        if (datas.get(0).length() > 64) {
                            errorMessage.append("[员工编码填写长度为1~64字]");
                        } else {
                            if (employeeMap.get(datas.get(0)) != null) {
                                errorMessage.append("[员工重复添加]");
                            } else {
                                CommonResponse<EmployeeVO> employeeData = employeeApi.getByEmpmloyeeCode(importVO.getPersonCode());
                                if (!employeeData.isSuccess()) {
                                    errorMessage.append("[人员管理中没有当前员工编码的人员]");
                                }else {
                                    if (null != employeeData.getData()) {
                                        employeeMap.put(datas.get(0), employeeData.getData());
                                        importVO.setPersonId(employeeMap.get(datas.get(0)).getId());
                                        importVO.setPersonName(employeeMap.get(datas.get(0)).getName());
                                    } else {
                                        errorMessage.append("[人员管理中没有当前员工编码的人员]");
                                    }
                                }
                            }
                        }
                    } else {
                        errorMessage.append("[员工编码为必填项]");
                    }




                    //姓名-personName
                    if (StringUtils.isBlank(datas.get(1))) {
                        errorMessage.append("[姓名为必填项]");
                    } else {
                        importVO.setPersonName(datas.get(1).trim());
                        if (!(employeeMap.get(datas.get(0)) != null && importVO.getPersonName().equals(employeeMap.get(datas.get(0)).getName()))) {
                            errorMessage.append("[姓名和员工编码不匹配]");
                        }
                    }



                    //单位社保金额-unitSocialSecurityMny
                    if (StringUtils.isNotBlank(datas.get(2))) {
                        try {
                            importVO.setUnitSocialSecurityMny(new BigDecimal(datas.get(2)));
                        } catch (Exception e) {
                            errorMessage.append("[单位社保金额必须为数字]");
                        }
                    }


                    //单位缴纳归属-unitPayBelong 单位缴纳归属：个人、公司、项目
                    if (StringUtils.isBlank(datas.get(3))) {
                        errorMessage.append("[单位缴纳归属为必填项]");
                    } else {
                        importVO.setUnitPayBelong(datas.get(3).trim());
                        if (!("个人".equals(datas.get(3)) || "公司".equals(datas.get(3)) || "项目".equals(datas.get(3)))) {
                            errorMessage.append("[请选择正确的单位缴纳归属]");
                        }
                    }

                    //个人社保金额-personSocialSecurityMny
                    if (StringUtils.isNotBlank(datas.get(4))) {
                        try {
                            importVO.setPersonSocialSecurityMny(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            errorMessage.append("[个人社保金额必须为数字]");
                        }
                    }

                    //支出金额-payMny
                    if (StringUtils.isNotBlank(datas.get(5))) {
                        try {
                            importVO.setPayMny(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            errorMessage.append("[支出金额必须为数字]");
                        }
                    }

                    //收入金额-incomeMny
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            importVO.setIncomeMny(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            errorMessage.append("[收入金额必须为数字]");
                        }
                    }



                    //项目编码-projectCode
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        if (StringUtils.isBlank(datas.get(7))){
                            errorMessage.append("[未填写项目名称]");
                        }
                        importVO.setProjectCode(datas.get(8).trim());
                        if (datas.get(8).length() > 64) {
                            errorMessage.append("[填写项目编码长度为1~64字]");
                        } else {
                            if (projectMap.get(datas.get(8)) != null) {
                                importVO.setProjectId(projectMap.get(datas.get(8)).getId());
                                importVO.setProjectName(projectMap.get(datas.get(8)).getName());
                            } else {
                                queryProjectParam.getParams().put("withoutOrgFlag", new Parameter(QueryParam.EQ, true));
                                queryProjectParam.getParams().put("status", new Parameter(QueryParam.EQ, 2));
                                queryProjectParam.getParams().put("validStatus", new Parameter(QueryParam.EQ, 0));
                                queryProjectParam.getParams().put("code", new Parameter(QueryParam.EQ, datas.get(8).trim()));


                                CommonResponse<List<ProjectRegisterVO>> projectData = projectApi.queryAllProj(queryProjectParam);
                                if (!projectData.isSuccess()) {
                                    errorMessage.append("[项目立项不存在当前项目编码的在建、启用项目]");
                                }else {
                                    if (CollectionUtils.isNotEmpty(projectData.getData()) && null != projectData.getData().get(0)) {
                                        projectMap.put(datas.get(8), projectData.getData().get(0));
                                        importVO.setProjectId(projectMap.get(datas.get(8)).getId());
                                        importVO.setProjectName(projectMap.get(datas.get(8)).getName());
                                    } else {
                                        errorMessage.append("[项目立项不存在当前项目编码的在建、启用项目]");
                                    }
                                }
                            }
                        }
                    }

                    //所属项目-projectName
                    if (StringUtils.isNotBlank(datas.get(7))){
                        importVO.setProjectName(datas.get(7).trim());
                        if (!(projectMap.get(datas.get(8)) != null && importVO.getProjectName().equals(projectMap.get(datas.get(8)).getName()))) {
                            errorMessage.append("[项目名称和项目编码不匹配]");
                        }
                    }


                    //备注-memo
                    if (datas.get(9).length() > 200){
                        importVO.setErrorMessage("填写备注长度为0~200字");
                    }
                    importVO.setMemo(datas.get(9));

                    importVO.setId(IdWorker.getId());
                    importVO.setSourceType(1);


                    if (StringUtils.isBlank(errorMessage)) {
                        successList.add(importVO);
                    }else {
                        importVO.setErrorMessage(String.valueOf(errorMessage));
                        errorList.add(importVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }
}
