package com.ejianc.business.oa.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.oa.service.IAwardService;
import com.ejianc.business.oa.service.IBidService;
import com.ejianc.business.oa.vo.AwardVO;
import com.ejianc.business.oa.vo.BidDetailVO;
import com.ejianc.business.oa.vo.BidVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/oa/")
public class OaApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Value("${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IBidService bidService;
    @Autowired
    private IAwardService awardService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOrgApi orgApi;

    /**
     * 查询投标文件评审--投标人员选择
     *
     * @return
     */
    @RequestMapping(value = "queryBidDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BidDetailVO>> queryBidDetailList(@RequestParam(value = "opportunityId") Long opportunityId) {
        return CommonResponse.success("查询成功！", bidService.queryBidDetailList(opportunityId));
    }

    /**
     * 查询投标文件评审--投标人员选择
     *
     * @return
     */
    @RequestMapping(value = "queryAwardByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AwardVO>> queryAwardByProjectId(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询成功！", awardService.queryAwardByProjectId(projectId));
    }

}
