/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.oa.bean.CALockRegisterEntity;
import com.ejianc.business.oa.mapper.CALockRegisterMapper;
import com.ejianc.business.oa.service.ICALockRegisterService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="cALockRegisterService")
public class CALockRegisterServiceImpl
extends BaseServiceImpl<CALockRegisterMapper, CALockRegisterEntity>
implements ICALockRegisterService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;

    @Override
    public String sendCAMsgToPerson() {
        this.logger.info("\u5f00\u59cb\u5b9a\u65f6\u4efb\u52a1\uff1a----");
        LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
        lambda2.in(CALockRegisterEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String nowStr = formatter.format(new Date());
        lambda2.eq(CALockRegisterEntity::getRemindDate, (Object)(nowStr + " 00:00:00"));
        List caLockRegisterEntityList = super.list((Wrapper)lambda2);
        String msg = "";
        if (CollectionUtils.isNotEmpty((Collection)caLockRegisterEntityList)) {
            for (CALockRegisterEntity caLockRegisterEntity : caLockRegisterEntityList) {
                msg = this.sendMsg(caLockRegisterEntity, "CA\u9501\u5355\u636e\u529e\u7406\u5ef6\u671f", "\u60a8\u597d\uff0c\u4eca\u5929\u662f\u201c" + caLockRegisterEntity.getCaLockName() + "\u201d\u529e\u7406\u5ef6\u671f\u7684\u63d0\u9192\u65e5\uff0c\u8bf7\u5c3d\u5feb\u529e\u7406\u5ef6\u671f\uff0c\u5982\u5df2\u529e\u7406\u8bf7\u5ffd\u7565");
                if (!StringUtils.isNotBlank((CharSequence)msg)) continue;
                this.logger.error("CA\u9501\u5230\u671f\u63d0\u9192\u53d1\u9001\u4fe1\u606f\u5f02\u5e38\uff1a" + msg);
            }
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff01");
        return msg;
    }

    private String sendMsg(CALockRegisterEntity caLockRegisterEntity, String subject, String content) {
        Object[] msgRecUserIds = new String[]{};
        msgRecUserIds = caLockRegisterEntity.getHeadId() == caLockRegisterEntity.getEmployeeId() ? new String[]{caLockRegisterEntity.getEmployeeId().toString()} : new String[]{caLockRegisterEntity.getHeadId().toString(), caLockRegisterEntity.getEmployeeId().toString()};
        this.logger.info("\u6d88\u606f\u63a5\u6536\u4eba: {}", (Object)StringUtils.join((Object[])msgRecUserIds, (String)","));
        for (Object msgRecUserId : msgRecUserIds) {
            PushMsgParameter msgParameter = new PushMsgParameter();
            msgParameter.setReceivers(new String[]{msgRecUserId});
            String userName = ((String)msgRecUserId).equals(caLockRegisterEntity.getEmployeeId().toString()) ? caLockRegisterEntity.getEmployeeName() : caLockRegisterEntity.getHeadName();
            msgParameter.setContent(userName + content);
            msgParameter.setSubject(subject);
            msgParameter.setMsgType("notice");
            msgParameter.setTenantId(caLockRegisterEntity.getTenantId().toString());
            msgParameter.setSaveFlag(true);
            msgParameter.setPcUrl("/ejc-oa-frontend/#/caLockRegister/card?id=" + caLockRegisterEntity.getId());
            msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
            msgParameter.setChannel(new String[]{"sys"});
            this.logger.info("\u53d1\u9001\u6d88\u606f\u4fe1\u606f: {}", (Object)JSONObject.toJSONString((Object)msgParameter));
            CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
            if (msgSendResp.isSuccess()) continue;
            return msgSendResp.getMsg();
        }
        return null;
    }
}

