package com.ejianc.business.oa.controller.api;

import com.ejianc.business.oa.bean.ManagementEntity;
import com.ejianc.business.oa.service.IManagementService;
import com.ejianc.business.oa.vo.ManagementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;


/**
 * @description: CertManagementApi
 *
 * @author songlx
 * @date: 2024/4/12
 */
@RestController
@RequestMapping(value = "/api/certManagement/")
public class CertManagementApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IManagementService service;


    /**
     * @description: 证照列表查询
     *
     * @param param
     * @return {@link CommonResponse< List< ManagementVO>>}
     * @author songlx
     * @date: 2024/4/12
     */
    @RequestMapping(value = "getCertList", method = RequestMethod.POST)
    CommonResponse<List<ManagementVO>> getCertList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("certName");
        fuzzyFields.add("certCode");
        fuzzyFields.add("name");
        fuzzyFields.add("certTypeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("certMajor");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<ManagementEntity> managementEntities = service.queryList(param);
        List<ManagementVO> managementVOS = BeanMapper.mapList(managementEntities, ManagementVO.class);
        return CommonResponse.success("查询列表数据成功！", managementVOS);
    }


}
