package com.ejianc.business.procBid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 物资设备类定标会签-主表
 * 
 * @author generator
 * 
 */
public class ProcBidApprovalVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String memo; // 备注
    private Integer billState; // 单据状态
    private Long purchaseId; // 采购事项ID
    private String purchaseCode; // 采购事项CODE
    private String purchaseName; // 采购事项NAME
    private BigDecimal winningMny; // 中标金额(预估标的物金额)
    private String procType; // 招采类型
    private String procMethod; // 招采类型
    @JsonFormat(
        shape = JsonFormat.Shape.STRING,
        pattern = "yyyy-MM-dd HH:mm:ss",
        timezone = "GMT+8"
    )
    private Date approvedTime; // 审批通过时间
    
    private List<ProcBidApprovalDetailVO> detailList = new ArrayList<>(); // 物资设备类定标会签-子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="proc-report-manager")
    public Long getPurchaseId() {
        return purchaseId;
    }

    @ReferDeserialTransfer
    public void setPurchaseId(Long purchaseId) {
        this.purchaseId = purchaseId;
    }
    public String getPurchaseCode() {
        return purchaseCode;
    }

    public void setPurchaseCode(String purchaseCode) {
        this.purchaseCode = purchaseCode;
    }
    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }
    public BigDecimal getWinningMny() {
        return winningMny;
    }

    public void setWinningMny(BigDecimal winningMny) {
        this.winningMny = winningMny;
    }
    public String getProcType() {
        return procType;
    }

    public void setProcType(String procType) {
        this.procType = procType;
    }
    public String getProcMethod() {
        return procMethod;
    }

    public void setProcMethod(String procMethod) {
        this.procMethod = procMethod;
    }


    public List<ProcBidApprovalDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ProcBidApprovalDetailVO> detailList) {
        this.detailList = detailList;
    }

    public Date getApprovedTime() {
        return approvedTime;
    }

    public void setApprovedTime(Date approvedTime) {
        this.approvedTime = approvedTime;
    }
}
