package com.ejianc.business.home.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/**
 * @author yqls
 * @date 2022-02-14 14:13:47
 */
@Component
public class CommonListCallable implements Callable<JSONArray> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final static String columns = "*";

    private QueryParam queryParam;
    private IBaseService service;
    private String databaseName;
    private String tableName;
    private String parameter;
    private static ICommenQueryFieldsService commonService;
    private static IBillTypeApi billTypeApi;

    @Autowired
    public void setCommonService (ICommenQueryFieldsService commonService){
        this.commonService = commonService;
    }

    @Autowired
    public void setBillTypeApi (IBillTypeApi billTypeApi){
        this.billTypeApi = billTypeApi;
    }

    public CommonListCallable() {
        // 必须有
    }

    /**
     *  注入service使用Callable查询数据列表
     * @param threadPool
     * @param queryParam
     * @param service
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     */
    public static Future<JSONArray> excute(ExecutorService threadPool, QueryParam queryParam, IBaseService service) {
        Callable<JSONArray> callable = new CommonListCallable(queryParam, service);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public CommonListCallable(QueryParam queryParam, IBaseService service) {
        this.queryParam = queryParam;
        this.service = service;
    }

    /**
     *  注入billTypeCode使用Callable查询数据列表
     * @param threadPool
     * @param queryParam
     * @param billTypeCode
     * @return
     * @throws ExecutionException
     * @throws InterruptedException
     */
    public static Future<JSONArray> excute(ExecutorService threadPool, QueryParam queryParam, String billTypeCode) {
        CommonResponse<MdReferVO> billTypeResponse = billTypeApi.queryMetadataByBillType(billTypeCode);
        if(!billTypeResponse.isSuccess()) {
            throw new BusinessException(billTypeResponse.getMsg());
        }
        MdReferVO referVo = billTypeResponse.getData();
        String parameter = ParamUtil.paramToString(queryParam.getParams());
        Callable<JSONArray> callable = new CommonListCallable(referVo.getDatabaseName(), referVo.getTableName(), parameter);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    /**
     * tableName查询
     * @param threadPool
     * @param queryParam
     * @param databaseName
     * @param tableName
     * @return
     */
    public static Future<JSONArray> excute(ExecutorService threadPool, QueryParam queryParam, String databaseName, String tableName) {
        String parameter = ParamUtil.paramToString(queryParam.getParams());
        Callable<JSONArray> callable = new CommonListCallable(databaseName, tableName, parameter);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public CommonListCallable(String databaseName, String tableName, String parameter) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.parameter = parameter;
    }

    @Override
    public JSONArray call() throws Exception {
        if(service != null) {
            List<T> list = service.queryList(queryParam, false);
            String json = JSON.toJSONString(list);
            JSONArray records = JSONArray.parseArray(json);
            return records;
        }
        logger.info("sql====" + "select {} from `{}`.{} where {}", columns, databaseName, tableName, parameter);
        JSONArray array = commonService.queryBillInfoByProperty(databaseName, tableName, columns, parameter);
        return array;
    }

}
