package com.ejianc.business.oa.controller;

// 工具类
import cn.hutool.core.date.DateUtil;   // 日期处理
import org.apache.commons.collections.CollectionUtils;  // 集合工具
import org.apache.commons.lang3.StringUtils;  // 字符串工具
// 分页
import com.baomidou.mybatisplus.core.metadata.IPage;
// 业务相关
import com.ejianc.business.oa.query.WeeklyReportCollectionQuery;
import com.ejianc.business.oa.service.IWeeklyReportCollectionService;
//import com.ejianc.business.oa.utils.ExportExcelUtil;
import com.ejianc.business.oa.vo.WeeklyReportCollectionVO;

// 1. 查询参数对象（DTO）
//import com.ejianc.business.hk.query.ProjectAccountabilityAllocationQuery;
// 需要手写：定义查询参数（如分页参数、过滤条件等）
//----------------------
// 2. Service接口
//import com.ejianc.business.hk.service.IProjectAccountabilityAllocationService;
// 需要手写：定义业务逻辑接口（如查询报表数据的方法）
//----------------------
// 3. Excel导出工具类
//import com.ejianc.business.hk.utils.ExportExcelUtil;
// 可能需要手写：如果这个工具类是项目自定义的Excel处理逻辑
//----------------------
// 4. 视图对象（VO）
//import com.ejianc.business.hk.vo.ProjectAccountabilityAllocationVO;
// 需要手写：定义返回给前端的结构化数据格式

// 框架响应
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
// Spring相关
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
// Servlet
import javax.servlet.http.HttpServletResponse;
// Java基础
import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
// 未使用的实体类
// ---
// 未使用的工具类
//import com.ejianc.business.hk.utils.CellModel;
// 未使用的VO类
//import com.ejianc.business.hk.vo.SunkCostReportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
// 未使用的框架组件
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;


/**
 * 这个Controller是和施工周报相关的接口的Controller
 * 作用是：收款登记的下面项目的所有的收款相关，然后把数据交给前端来处理
 * 相关的数据如下
 * 收款登记：此项目的项目ID、该项目每个单据的办理时间、该项目每个单据的收款金额
 */
@Controller
@RequestMapping("weeklyReportCollectionPerson")
public class WeeklyReportCollectionController {

    // @Autowired 是 Spring 框架提供的一个注解，主要用于自动装配依赖项。
    @Autowired
    private IWeeklyReportCollectionService weeklyReportCollectionService;

    @RequestMapping(value = "/queryWeeklyReportCollectionList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeeklyReportCollectionVO>> queryProjectAccountabilityAllocationList(@RequestBody WeeklyReportCollectionQuery query) {

        IPage<WeeklyReportCollectionVO> page = weeklyReportCollectionService.queryWeeklyReportCollectionList(query);

        // 查询数据
        return CommonResponse.success("查询列表数据成功！",page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 导出没用
     */
    //导出没用
    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody WeeklyReportCollectionQuery query, HttpServletResponse response) {
        query.setDisAblePage(true);
        IPage<WeeklyReportCollectionVO> list = weeklyReportCollectionService.queryWeeklyReportCollectionList(query);

        // 设置导出数据
        List<List<Object>> data = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list.getRecords())) {
            for (WeeklyReportCollectionVO item : list.getRecords()) {
                List<Object> row = new ArrayList<>();
                row.add(item.getMemberName()); //姓名
                data.add(row);
            }
        }

        // 导出Excel文件的文件名
        String fileName = "projectAccountabilityAllocationPerson"+ DateUtil.now()+".xlsx";

        // 跳过行数默认为表头行数(excel从0开始计算行)
        Integer skipRows = 2;

        // 使用传统的for循环给每个List<Object>的头部添加序号
        if (CollectionUtils.isNotEmpty(data)) {
            int index = 1;
            for (List<Object> objects : data) {
                objects.add(0, index++);
            }
        }

        // 调用工具类导出Excel
//        ExportExcelUtil.export("ProjectAccountabilityAllocationPerson-export.xlsx", skipRows, fileName, data, null, response);

    }
}