package com.ejianc.business.oa.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.oa.bean.BidDetailEntity;
import com.ejianc.business.oa.service.IBidDetailService;
import com.ejianc.business.oa.vo.BidDetailVO;
import com.ejianc.business.oa.vo.BidVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.oa.mapper.BidMapper;
import com.ejianc.business.oa.bean.BidEntity;
import com.ejianc.business.oa.service.IBidService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 投标文件评审实体
 * 
 * @author generator
 * 
 */
@Service("bidService")
public class BidServiceImpl extends BaseServiceImpl<BidMapper, BidEntity> implements IBidService{

    @Autowired
    private IBidService service;

    @Autowired
    private IBidDetailService detailService;
    @Override
    public List<BidDetailVO> queryBidDetailList(Long opportunityId) {
        LambdaQueryWrapper<BidEntity> lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(BidEntity::getOpportunityId,opportunityId);
        lambdaQueryWrapper.in(BidEntity::getBillState,1,3);
        lambdaQueryWrapper.eq(BidEntity::getDr,0);
        List<BidEntity> list = service.list(lambdaQueryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return  null;

        }
        List<Long> ids = list.stream().map(BidEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<BidDetailEntity> detailWrapper=Wrappers.lambdaQuery();
        detailWrapper.in(BidDetailEntity::getBidId,ids);
        detailWrapper.eq(BidDetailEntity::getDr,0);
        List<BidDetailEntity> detailList = detailService.list(detailWrapper);
        return  BeanMapper.mapList(detailList, BidDetailVO.class);
    }
}
