package com.ejianc.business.procBid.controller;

import cn.hutool.core.date.DateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.baomidou.mybatisplus.core.metadata.IPage;

import com.ejianc.business.procBid.query.ProcBidReportQuery;
import com.ejianc.business.procBid.service.IProcBidReportService;
import com.ejianc.business.procBid.utils.ExportExcelUtil;
import com.ejianc.business.procBid.vo.ProcBidReportVO;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;

import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

import com.ejianc.foundation.orgcenter.vo.OrgVO;

import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;

@Controller
@RequestMapping("procBidReportPerson")
public class ProcBidReportController {

    // @Autowired 是 Spring 框架提供的一个注解，主要用于自动装配依赖项。
    @Autowired
    private IProcBidReportService procBidReportService;

    @RequestMapping(value = "/queryProcBidReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProcBidReportVO>> queryProcBidReportList(@RequestBody ProcBidReportQuery query) {

        IPage<ProcBidReportVO> page = procBidReportService.queryProcBidReportList(query);

        // 查询数据
        return CommonResponse.success("查询列表数据成功！",page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody ProcBidReportQuery query, HttpServletResponse response) {
        query.setDisAblePage(true);
        IPage<ProcBidReportVO> list = procBidReportService.queryProcBidReportList(query);

        // 设置导出数据
        List<List<Object>> data = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list.getRecords())) {
            for (ProcBidReportVO item : list.getRecords()) {
                List<Object> row = new ArrayList<>();

                String procType = item.getProcType();
                String procTypeDesc;
                switch (procType) {
                    case "1":
                        procTypeDesc = "单项目招标";
                        break;
                    case "2":
                        procTypeDesc = "集采招标";
                        break;
                    default:
                        procTypeDesc = procType;
                }
                row.add(procTypeDesc);// 招采类型（已转换为中文）

                row.add(item.getPurchaseCode()); //采购事项CODE
                row.add(item.getPurchaseName()); //采购事项CODE
                row.add(item.getProjectCode());//项目CODE
                row.add(item.getProjectName());//项目NAME
                row.add(item.getProfession());// 专业
                row.add(item.getProcCategory());//招采品类
                row.add(item.getEstimatedMny());//预估标的物金额

                // 1. 计划到货/进场时间：转换为yyyy-MM-dd字符串（处理null）
                row.add(item.getPlanArrivalTime() == null ? "" : DateUtil.format(item.getPlanArrivalTime(), "yyyy-MM-dd"));
                // 2. 预计货期/进场准备（天）
                row.add(item.getEstPrepDay());
                // 3. 计划定标时间：转换为yyyy-MM-dd字符串（处理null）
                row.add(item.getPlanBidTime() == null ? "" : DateUtil.format(item.getPlanBidTime(), "yyyy-MM-dd"));
                // 4. 剩余时间（天）
                row.add(item.getRemainDay());
                // 5. 单位入围审批通过时间：转换为yyyy-MM-dd字符串（处理null）
                row.add(item.getSupplierApprovedTime() == null ? "" : DateUtil.format(item.getSupplierApprovedTime(), "yyyy-MM-dd"));
                // 6. 招标文件审批通过时间：转换为yyyy-MM-dd字符串（处理null）
                row.add(item.getBidDocApprovedTime() == null ? "" : DateUtil.format(item.getBidDocApprovedTime(), "yyyy-MM-dd"));
                // 7. 定标单位审批通过时间：转换为yyyy-MM-dd字符串（处理null）
                row.add(item.getBidApprovedTime() == null ? "" : DateUtil.format(item.getBidApprovedTime(), "yyyy-MM-dd"));

                row.add(item.getWinningMny());//定标金额
                data.add(row);
            }
        }

        // 导出Excel文件的文件名
        String fileName = "procBidReportPerson"+ DateUtil.now()+".xlsx";

        // 跳过行数默认为表头行数(excel从0开始计算行)
        Integer skipRows = 2;

        // 使用传统的for循环给每个List<Object>的头部添加序号
        if (CollectionUtils.isNotEmpty(data)) {
            int index = 1;
            for (List<Object> objects : data) {
                objects.add(0, index++);
            }
        }

        // 调用工具类导出Excel
        ExportExcelUtil.export("ProcBidReportPerson-export.xlsx", skipRows, fileName, data, null, response);

    }
}