/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.procBid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.home.util.ParamUtil;
import com.ejianc.business.procBid.bean.ProcReportManagerEntity;
import com.ejianc.business.procBid.service.IProcReportManagerService;
import com.ejianc.business.procBid.utils.DateUtils;
import com.ejianc.business.procBid.vo.ProcReportManagerVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"procReportManager"})
public class ProcReportManagerController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "CGSP";
    @Autowired
    private IProcReportManagerService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProcReportManagerVO> saveOrUpdate(@RequestBody ProcReportManagerVO saveOrUpdateVO) {
        ProcReportManagerEntity entity = (ProcReportManagerEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ProcReportManagerEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProcReportManagerVO vo = (ProcReportManagerVO)((Object)BeanMapper.map((Object)((Object)entity), ProcReportManagerVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProcReportManagerVO> queryDetail(Long id) {
        ProcReportManagerEntity entity = (ProcReportManagerEntity)((Object)this.service.selectById(id));
        ProcReportManagerVO vo = (ProcReportManagerVO)((Object)BeanMapper.map((Object)((Object)entity), ProcReportManagerVO.class));
        Date currentTime = new Date();
        int remainDay = DateUtils.getDaysBetween(vo.getPlanBidTime(), currentTime);
        vo.setRemainDay(remainDay);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProcReportManagerVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProcReportManagerVO procReportManagerVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProcReportManagerVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("purchaseItem");
        fuzzyFields.add("profession");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Date currentTime = new Date();
        page.getRecords().forEach(item -> {
            int remainDay = DateUtils.getDaysBetween(item.getPlanBidTime(), currentTime);
            item.setRemainDay(remainDay);
        });
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProcReportManagerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("purchaseItem");
        fuzzyFields.add("profession");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        Date currentTime = new Date();
        list.forEach(vo -> {
            switch (vo.getProcType()) {
                case "1": {
                    vo.setProcType("\u5355\u9879\u76ee\u62db\u6807");
                    break;
                }
                case "2": {
                    vo.setProcType("\u96c6\u91c7\u62db\u6807");
                    break;
                }
                default: {
                    vo.setProcType("");
                }
            }
            int remainDay = DateUtils.getDaysBetween(vo.getPlanBidTime(), currentTime);
            vo.setRemainDay(remainDay);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("ProcReportManager-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProcReportManagerData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProcReportManagerVO>> refProcReportManagerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        param.getFuzzyFields().addAll(Arrays.asList("projectName", "purchaseItem", "profession"));
        param.getOrderMap().put("createTime", "desc");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        String sql = ParamUtil.getSql(param, "T");
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        List<ProcReportManagerVO> list = this.service.refProcReportManagerData((IPage<ProcReportManagerVO>)page, sql);
        Date currentTime = new Date();
        list.forEach(vo -> {
            int remainDay = DateUtils.getDaysBetween(vo.getPlanBidTime(), currentTime);
            vo.setRemainDay(remainDay);
        });
        page.setRecords(BeanMapper.mapList(list, ProcReportManagerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/refProcReportManagerDataHQ"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProcReportManagerVO>> refProcReportManagerDataHQ(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        param.getFuzzyFields().addAll(Arrays.asList("projectName", "purchaseItem", "profession"));
        String sql = ParamUtil.getSql(param, "T");
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        List<ProcReportManagerVO> list = this.service.refProcReportManagerDataHQ((IPage<ProcReportManagerVO>)page, sql);
        Date currentTime = new Date();
        list.forEach(vo -> {
            int remainDay = DateUtils.getDaysBetween(vo.getPlanBidTime(), currentTime);
            vo.setRemainDay(remainDay);
        });
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

