package com.ejianc.business.procBid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.procBid.bean.BidDocEntity;
import com.ejianc.business.procBid.bean.ProcBidApprovalEntity;
import com.ejianc.business.procBid.bean.ProcReportManagerEntity;
import com.ejianc.business.procBid.bean.SupplierApprovalEntity;
import com.ejianc.business.procBid.service.IBidDocService;
import com.ejianc.business.procBid.service.IProcBidApprovalService;
import com.ejianc.business.procBid.service.IProcReportManagerService;
import com.ejianc.business.procBid.service.ISupplierApprovalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;

@Service("procReportManager") 
public class ProcReportManagerBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IProcReportManagerService service;

	@Autowired
    private ISupplierApprovalService supplierApprovalService;

	@Autowired
    private IBidDocService bidDocService;

	@Autowired
    private IProcBidApprovalService procBidApprovalService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		// 更新审批时间
		ProcReportManagerEntity entity = service.getById(billId);
		if(entity == null) {
			return CommonResponse.error("单据不存在！");
		}
		entity.setApprovedTime(new Date());
		service.saveOrUpdate(entity,false);
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		// 如果存在被下游单据引用则提示被引用单据，表示无法删除
		ProcReportManagerEntity entity = service.getById(billId);
		if(entity == null) {
			return CommonResponse.error("单据不存在！");
		}
		// 查询"投标单位入围名单审批表"是否存在引用单据
		LambdaQueryWrapper<SupplierApprovalEntity> query = new LambdaQueryWrapper<>();
		query.eq(SupplierApprovalEntity::getPurchaseId, billId);
		SupplierApprovalEntity supplierApprovalEntity = supplierApprovalService.getOne(query);
		if (supplierApprovalEntity != null) {
			String billCode = supplierApprovalEntity.getBillCode(); // 重点：用实际值替换字符串
			return CommonResponse.error("单据被下游单据引用: " + billCode + "，请先删除被引用单据！");
		}
		//查询"物资设备类招标文件会签表"是否存在引用单据
		LambdaQueryWrapper<BidDocEntity> query2 = new LambdaQueryWrapper<>();
		query2.eq(BidDocEntity::getPurchaseId, billId);
		BidDocEntity bidDocEntity = bidDocService.getOne(query2);
		if (bidDocEntity != null) {
			String billCode = bidDocEntity.getBillCode();
			return CommonResponse.error("单据被下游单据引用: " + billCode + "，请先删除被引用单据！");
		}
		// 查询"物资设备类定标会签"是否存在引用单据
		LambdaQueryWrapper<ProcBidApprovalEntity> query3 = new LambdaQueryWrapper<>();
		query3.eq(ProcBidApprovalEntity::getPurchaseId, billId);
		ProcBidApprovalEntity procBidApprovalEntity = procBidApprovalService.getOne(query3);
		if (procBidApprovalEntity != null) {
			String billCode = procBidApprovalEntity.getBillCode();
			return CommonResponse.error("单据被下游单据引用: " + billCode + "，请先删除被引用单据！");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
